/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module testmodel-js/collection_tck */
var utils = require('vertx-js/util/utils');
var RefedInterface1 = require('testmodel-js/refed_interface1');
var RefedInterface2 = require('testmodel-js/refed_interface2');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JCollectionTCK = Java.type('io.vertx.codegen.testmodel.CollectionTCK');
var TestDataObject = Java.type('io.vertx.codegen.testmodel.TestDataObject');

/**

 @class
*/
var CollectionTCK = function(j_val) {

  var j_collectionTCK = j_val;
  var that = this;

  var __super_methodWithListParams = this.methodWithListParams;
  var __super_methodWithSetParams = this.methodWithSetParams;
  var __super_methodWithMapParams = this.methodWithMapParams;
  var __super_methodWithHandlerListAndSet = this.methodWithHandlerListAndSet;
  var __super_methodWithHandlerAsyncResultListString = this.methodWithHandlerAsyncResultListString;
  var __super_methodWithHandlerAsyncResultListInteger = this.methodWithHandlerAsyncResultListInteger;
  var __super_methodWithHandlerListVertxGen = this.methodWithHandlerListVertxGen;
  var __super_methodWithHandlerListAbstractVertxGen = this.methodWithHandlerListAbstractVertxGen;
  var __super_methodWithHandlerListJsonObject = this.methodWithHandlerListJsonObject;
  var __super_methodWithHandlerListComplexJsonObject = this.methodWithHandlerListComplexJsonObject;
  var __super_methodWithHandlerListJsonArray = this.methodWithHandlerListJsonArray;
  var __super_methodWithHandlerListComplexJsonArray = this.methodWithHandlerListComplexJsonArray;
  var __super_methodWithHandlerListDataObject = this.methodWithHandlerListDataObject;
  var __super_methodWithHandlerListEnum = this.methodWithHandlerListEnum;
  var __super_methodWithHandlerAsyncResultSetString = this.methodWithHandlerAsyncResultSetString;
  var __super_methodWithHandlerAsyncResultSetInteger = this.methodWithHandlerAsyncResultSetInteger;
  var __super_methodWithHandlerSetVertxGen = this.methodWithHandlerSetVertxGen;
  var __super_methodWithHandlerSetAbstractVertxGen = this.methodWithHandlerSetAbstractVertxGen;
  var __super_methodWithHandlerSetJsonObject = this.methodWithHandlerSetJsonObject;
  var __super_methodWithHandlerSetComplexJsonObject = this.methodWithHandlerSetComplexJsonObject;
  var __super_methodWithHandlerSetJsonArray = this.methodWithHandlerSetJsonArray;
  var __super_methodWithHandlerSetComplexJsonArray = this.methodWithHandlerSetComplexJsonArray;
  var __super_methodWithHandlerSetDataObject = this.methodWithHandlerSetDataObject;
  var __super_methodWithHandlerSetEnum = this.methodWithHandlerSetEnum;
  var __super_methodWithHandlerAsyncResultListVertxGen = this.methodWithHandlerAsyncResultListVertxGen;
  var __super_methodWithHandlerAsyncResultListAbstractVertxGen = this.methodWithHandlerAsyncResultListAbstractVertxGen;
  var __super_methodWithHandlerAsyncResultListJsonObject = this.methodWithHandlerAsyncResultListJsonObject;
  var __super_methodWithHandlerAsyncResultListComplexJsonObject = this.methodWithHandlerAsyncResultListComplexJsonObject;
  var __super_methodWithHandlerAsyncResultListJsonArray = this.methodWithHandlerAsyncResultListJsonArray;
  var __super_methodWithHandlerAsyncResultListComplexJsonArray = this.methodWithHandlerAsyncResultListComplexJsonArray;
  var __super_methodWithHandlerAsyncResultListDataObject = this.methodWithHandlerAsyncResultListDataObject;
  var __super_methodWithHandlerAsyncResultListEnum = this.methodWithHandlerAsyncResultListEnum;
  var __super_methodWithHandlerAsyncResultSetVertxGen = this.methodWithHandlerAsyncResultSetVertxGen;
  var __super_methodWithHandlerAsyncResultSetAbstractVertxGen = this.methodWithHandlerAsyncResultSetAbstractVertxGen;
  var __super_methodWithHandlerAsyncResultSetJsonObject = this.methodWithHandlerAsyncResultSetJsonObject;
  var __super_methodWithHandlerAsyncResultSetComplexJsonObject = this.methodWithHandlerAsyncResultSetComplexJsonObject;
  var __super_methodWithHandlerAsyncResultSetJsonArray = this.methodWithHandlerAsyncResultSetJsonArray;
  var __super_methodWithHandlerAsyncResultSetComplexJsonArray = this.methodWithHandlerAsyncResultSetComplexJsonArray;
  var __super_methodWithHandlerAsyncResultSetDataObject = this.methodWithHandlerAsyncResultSetDataObject;
  var __super_methodWithHandlerAsyncResultSetEnum = this.methodWithHandlerAsyncResultSetEnum;
  var __super_methodWithMapStringReturn = this.methodWithMapStringReturn;
  var __super_methodWithMapLongReturn = this.methodWithMapLongReturn;
  var __super_methodWithMapIntegerReturn = this.methodWithMapIntegerReturn;
  var __super_methodWithMapShortReturn = this.methodWithMapShortReturn;
  var __super_methodWithMapByteReturn = this.methodWithMapByteReturn;
  var __super_methodWithMapCharacterReturn = this.methodWithMapCharacterReturn;
  var __super_methodWithMapBooleanReturn = this.methodWithMapBooleanReturn;
  var __super_methodWithMapFloatReturn = this.methodWithMapFloatReturn;
  var __super_methodWithMapDoubleReturn = this.methodWithMapDoubleReturn;
  var __super_methodWithMapJsonObjectReturn = this.methodWithMapJsonObjectReturn;
  var __super_methodWithMapComplexJsonObjectReturn = this.methodWithMapComplexJsonObjectReturn;
  var __super_methodWithMapJsonArrayReturn = this.methodWithMapJsonArrayReturn;
  var __super_methodWithMapComplexJsonArrayReturn = this.methodWithMapComplexJsonArrayReturn;
  var __super_methodWithMapObjectReturn = this.methodWithMapObjectReturn;
  var __super_methodWithListStringReturn = this.methodWithListStringReturn;
  var __super_methodWithListLongReturn = this.methodWithListLongReturn;
  var __super_methodWithListVertxGenReturn = this.methodWithListVertxGenReturn;
  var __super_methodWithListJsonObjectReturn = this.methodWithListJsonObjectReturn;
  var __super_methodWithListComplexJsonObjectReturn = this.methodWithListComplexJsonObjectReturn;
  var __super_methodWithListJsonArrayReturn = this.methodWithListJsonArrayReturn;
  var __super_methodWithListComplexJsonArrayReturn = this.methodWithListComplexJsonArrayReturn;
  var __super_methodWithListDataObjectReturn = this.methodWithListDataObjectReturn;
  var __super_methodWithListEnumReturn = this.methodWithListEnumReturn;
  var __super_methodWithListObjectReturn = this.methodWithListObjectReturn;
  var __super_methodWithSetStringReturn = this.methodWithSetStringReturn;
  var __super_methodWithSetLongReturn = this.methodWithSetLongReturn;
  var __super_methodWithSetVertxGenReturn = this.methodWithSetVertxGenReturn;
  var __super_methodWithSetJsonObjectReturn = this.methodWithSetJsonObjectReturn;
  var __super_methodWithSetComplexJsonObjectReturn = this.methodWithSetComplexJsonObjectReturn;
  var __super_methodWithSetJsonArrayReturn = this.methodWithSetJsonArrayReturn;
  var __super_methodWithSetComplexJsonArrayReturn = this.methodWithSetComplexJsonArrayReturn;
  var __super_methodWithSetDataObjectReturn = this.methodWithSetDataObjectReturn;
  var __super_methodWithSetEnumReturn = this.methodWithSetEnumReturn;
  var __super_methodWithSetObjectReturn = this.methodWithSetObjectReturn;
  /**

   @public
   @param listString {Array.<string>} 
   @param listByte {Array.<number>} 
   @param listShort {Array.<number>} 
   @param listInt {Array.<number>} 
   @param listLong {Array.<number>} 
   @param listJsonObject {Array.<Object>} 
   @param listJsonArray {Array.<Array>} 
   @param listVertxGen {Array.<RefedInterface1>} 
   @param listDataObject {Array.<Object>} 
   @param listEnum {Array.<Object>} 
   @param listObject {Array.<Object>} 
   */
  this.methodWithListParams =  function(listString, listByte, listShort, listInt, listLong, listJsonObject, listJsonArray, listVertxGen, listDataObject, listEnum, listObject) {
    var __args = arguments;
    if (__args.length === 11 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'object' && __args[2] instanceof Array && typeof __args[3] === 'object' && __args[3] instanceof Array && typeof __args[4] === 'object' && __args[4] instanceof Array && typeof __args[5] === 'object' && __args[5] instanceof Array && typeof __args[6] === 'object' && __args[6] instanceof Array && typeof __args[7] === 'object' && __args[7] instanceof Array && typeof __args[8] === 'object' && __args[8] instanceof Array && typeof __args[9] === 'object' && __args[9] instanceof Array && typeof __args[10] === 'object' && __args[10] instanceof Array) {
      j_collectionTCK["methodWithListParams(java.util.List,java.util.List,java.util.List,java.util.List,java.util.List,java.util.List,java.util.List,java.util.List,java.util.List,java.util.List,java.util.List)"](utils.convParamListBasicOther(__args[0]), utils.convParamListByte(__args[1]), utils.convParamListShort(__args[2]), utils.convParamListBasicOther(__args[3]), utils.convParamListLong(__args[4]), utils.convParamListJsonObject(__args[5]), utils.convParamListJsonArray(__args[6]), utils.convParamListVertxGen(__args[7]), utils.convParamListDataObject(__args[8], function(json) { return new TestDataObject(json); }), utils.convParamListEnum(__args[9], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); }), utils.convParamListObject(__args[10]));
    } else if (typeof __super_methodWithListParams != 'undefined') {
      return __super_methodWithListParams.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param setString {Array.<string>} 
   @param setByte {Array.<number>} 
   @param setShort {Array.<number>} 
   @param setInt {Array.<number>} 
   @param setLong {Array.<number>} 
   @param setJsonObject {Array.<Object>} 
   @param setJsonArray {Array.<Array>} 
   @param setVertxGen {Array.<RefedInterface1>} 
   @param setDataObject {Array.<Object>} 
   @param setEnum {Array.<Object>} 
   @param setObject {Array.<Object>} 
   */
  this.methodWithSetParams =  function(setString, setByte, setShort, setInt, setLong, setJsonObject, setJsonArray, setVertxGen, setDataObject, setEnum, setObject) {
    var __args = arguments;
    if (__args.length === 11 && typeof __args[0] === 'object' && __args[0] instanceof Array && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'object' && __args[2] instanceof Array && typeof __args[3] === 'object' && __args[3] instanceof Array && typeof __args[4] === 'object' && __args[4] instanceof Array && typeof __args[5] === 'object' && __args[5] instanceof Array && typeof __args[6] === 'object' && __args[6] instanceof Array && typeof __args[7] === 'object' && __args[7] instanceof Array && typeof __args[8] === 'object' && __args[8] instanceof Array && typeof __args[9] === 'object' && __args[9] instanceof Array && typeof __args[10] === 'object' && __args[10] instanceof Array) {
      j_collectionTCK["methodWithSetParams(java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set,java.util.Set)"](utils.convParamSetBasicOther(__args[0]), utils.convParamSetByte(__args[1]), utils.convParamSetShort(__args[2]), utils.convParamSetBasicOther(__args[3]), utils.convParamSetLong(__args[4]), utils.convParamSetJsonObject(__args[5]), utils.convParamSetJsonArray(__args[6]), utils.convParamSetVertxGen(__args[7]), utils.convParamSetDataObject(__args[8], function(json) { return new TestDataObject(json); }), utils.convParamSetEnum(__args[9], function(val) { return Packages.io.vertx.codegen.testmodel.TestEnum.valueOf(val); }), utils.convParamSetObject(__args[10]));
    } else if (typeof __super_methodWithSetParams != 'undefined') {
      return __super_methodWithSetParams.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param mapString {Object.<string, string>} 
   @param mapByte {Object.<string, number>} 
   @param mapShort {Object.<string, number>} 
   @param mapInt {Object.<string, number>} 
   @param mapLong {Object.<string, number>} 
   @param mapJsonObject {Object.<string, Object>} 
   @param mapJsonArray {Object.<string, Array>} 
   @param mapVertxGen {Object.<string, RefedInterface1>} 
   @param mapObject {Object.<string, Object>} 
   */
  this.methodWithMapParams =  function(mapString, mapByte, mapShort, mapInt, mapLong, mapJsonObject, mapJsonArray, mapVertxGen, mapObject) {
    var __args = arguments;
    if (__args.length === 9 && (typeof __args[0] === 'object' && __args[0] != null) && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && (typeof __args[4] === 'object' && __args[4] != null) && (typeof __args[5] === 'object' && __args[5] != null) && (typeof __args[6] === 'object' && __args[6] != null) && (typeof __args[7] === 'object' && __args[7] != null) && (typeof __args[8] === 'object' && __args[8] != null)) {
      j_collectionTCK["methodWithMapParams(java.util.Map,java.util.Map,java.util.Map,java.util.Map,java.util.Map,java.util.Map,java.util.Map,java.util.Map,java.util.Map)"](__args[0], utils.convParamMapByte(__args[1]), utils.convParamMapShort(__args[2]), __args[3], utils.convParamMapLong(__args[4]), utils.convParamMapJsonObject(__args[5]), utils.convParamMapJsonArray(__args[6]), utils.convParamMapVertxGen(__args[7]), utils.convParamMapObject(__args[8]));
    } else if (typeof __super_methodWithMapParams != 'undefined') {
      return __super_methodWithMapParams.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listStringHandler {function} 
   @param listIntHandler {function} 
   @param setStringHandler {function} 
   @param setIntHandler {function} 
   */
  this.methodWithHandlerListAndSet =  function(listStringHandler, listIntHandler, setStringHandler, setIntHandler) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'function' && typeof __args[1] === 'function' && typeof __args[2] === 'function' && typeof __args[3] === 'function') {
      j_collectionTCK["methodWithHandlerListAndSet(io.vertx.core.Handler,io.vertx.core.Handler,io.vertx.core.Handler,io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      }, function(jVal) {
        __args[1](jVal);
      }, function(jVal) {
        __args[2](utils.convReturnSet(jVal));
      }, function(jVal) {
        __args[3](utils.convReturnSet(jVal));
      });
    } else if (typeof __super_methodWithHandlerListAndSet != 'undefined') {
      return __super_methodWithHandlerListAndSet.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithHandlerAsyncResultListString =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListString(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListString != 'undefined') {
      return __super_methodWithHandlerAsyncResultListString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithHandlerAsyncResultListInteger =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListInteger(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](ar.result(), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListInteger != 'undefined') {
      return __super_methodWithHandlerAsyncResultListInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListVertxGen(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetVertxGen(jVal, RefedInterface1));
      });
    } else if (typeof __super_methodWithHandlerListVertxGen != 'undefined') {
      return __super_methodWithHandlerListVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListAbstractVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListAbstractVertxGen(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetVertxGen(jVal, RefedInterface2));
      });
    } else if (typeof __super_methodWithHandlerListAbstractVertxGen != 'undefined') {
      return __super_methodWithHandlerListAbstractVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListJsonObject(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerListJsonObject != 'undefined') {
      return __super_methodWithHandlerListJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListComplexJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListComplexJsonObject(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerListComplexJsonObject != 'undefined') {
      return __super_methodWithHandlerListComplexJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListJsonArray(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerListJsonArray != 'undefined') {
      return __super_methodWithHandlerListJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListComplexJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListComplexJsonArray(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerListComplexJsonArray != 'undefined') {
      return __super_methodWithHandlerListComplexJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListDataObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListDataObject(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetDataObject(jVal));
      });
    } else if (typeof __super_methodWithHandlerListDataObject != 'undefined') {
      return __super_methodWithHandlerListDataObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerListEnum =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerListEnum(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithHandlerListEnum != 'undefined') {
      return __super_methodWithHandlerListEnum.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithHandlerAsyncResultSetString =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetString(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetString != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetString.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   */
  this.methodWithHandlerAsyncResultSetInteger =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetInteger(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnSet(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetInteger != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetInteger.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerSetVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetVertxGen(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetVertxGen(jVal, RefedInterface1));
      });
    } else if (typeof __super_methodWithHandlerSetVertxGen != 'undefined') {
      return __super_methodWithHandlerSetVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerSetAbstractVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetAbstractVertxGen(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetVertxGen(jVal, RefedInterface2));
      });
    } else if (typeof __super_methodWithHandlerSetAbstractVertxGen != 'undefined') {
      return __super_methodWithHandlerSetAbstractVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerSetJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetJsonObject(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerSetJsonObject != 'undefined') {
      return __super_methodWithHandlerSetJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerSetComplexJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetComplexJsonObject(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerSetComplexJsonObject != 'undefined') {
      return __super_methodWithHandlerSetComplexJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerSetJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetJsonArray(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerSetJsonArray != 'undefined') {
      return __super_methodWithHandlerSetJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param setHandler {function} 
   */
  this.methodWithHandlerSetComplexJsonArray =  function(setHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetComplexJsonArray(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetJson(jVal));
      });
    } else if (typeof __super_methodWithHandlerSetComplexJsonArray != 'undefined') {
      return __super_methodWithHandlerSetComplexJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param setHandler {function} 
   */
  this.methodWithHandlerSetDataObject =  function(setHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetDataObject(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetDataObject(jVal));
      });
    } else if (typeof __super_methodWithHandlerSetDataObject != 'undefined') {
      return __super_methodWithHandlerSetDataObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param setHandler {function} 
   */
  this.methodWithHandlerSetEnum =  function(setHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerSetEnum(io.vertx.core.Handler)"](function(jVal) {
        __args[0](utils.convReturnListSetEnum(jVal));
      });
    } else if (typeof __super_methodWithHandlerSetEnum != 'undefined') {
      return __super_methodWithHandlerSetEnum.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListVertxGen(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetVertxGen(ar.result(), RefedInterface1), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListVertxGen != 'undefined') {
      return __super_methodWithHandlerAsyncResultListVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListAbstractVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListAbstractVertxGen(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetVertxGen(ar.result(), RefedInterface2), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListAbstractVertxGen != 'undefined') {
      return __super_methodWithHandlerAsyncResultListAbstractVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListJsonObject(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListJsonObject != 'undefined') {
      return __super_methodWithHandlerAsyncResultListJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListComplexJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListComplexJsonObject(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListComplexJsonObject != 'undefined') {
      return __super_methodWithHandlerAsyncResultListComplexJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListJsonArray(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListJsonArray != 'undefined') {
      return __super_methodWithHandlerAsyncResultListJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListComplexJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListComplexJsonArray(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListComplexJsonArray != 'undefined') {
      return __super_methodWithHandlerAsyncResultListComplexJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListDataObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListDataObject(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListDataObject != 'undefined') {
      return __super_methodWithHandlerAsyncResultListDataObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultListEnum =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultListEnum(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultListEnum != 'undefined') {
      return __super_methodWithHandlerAsyncResultListEnum.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetVertxGen(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetVertxGen(ar.result(), RefedInterface1), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetVertxGen != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetAbstractVertxGen =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetAbstractVertxGen(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetVertxGen(ar.result(), RefedInterface2), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetAbstractVertxGen != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetAbstractVertxGen.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetJsonObject(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetJsonObject != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetComplexJsonObject =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetComplexJsonObject(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetComplexJsonObject != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetComplexJsonObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetJsonArray(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetJsonArray != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param listHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetComplexJsonArray =  function(listHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetComplexJsonArray(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetJson(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetComplexJsonArray != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetComplexJsonArray.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param setHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetDataObject =  function(setHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetDataObject(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetDataObject(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetDataObject != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetDataObject.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param setHandler {function} 
   */
  this.methodWithHandlerAsyncResultSetEnum =  function(setHandler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_collectionTCK["methodWithHandlerAsyncResultSetEnum(io.vertx.core.Handler)"](function(ar) {
        if (ar.succeeded()) {
          __args[0](utils.convReturnListSetEnum(ar.result()), null);
        } else {
          __args[0](null, ar.cause());
        }
      });
    } else if (typeof __super_methodWithHandlerAsyncResultSetEnum != 'undefined') {
      return __super_methodWithHandlerAsyncResultSetEnum.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, string>}
   */
  this.methodWithMapStringReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapStringReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapStringReturn != 'undefined') {
      return __super_methodWithMapStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, number>}
   */
  this.methodWithMapLongReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapLongReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapLongReturn != 'undefined') {
      return __super_methodWithMapLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, number>}
   */
  this.methodWithMapIntegerReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapIntegerReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapIntegerReturn != 'undefined') {
      return __super_methodWithMapIntegerReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, number>}
   */
  this.methodWithMapShortReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapShortReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapShortReturn != 'undefined') {
      return __super_methodWithMapShortReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, number>}
   */
  this.methodWithMapByteReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapByteReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapByteReturn != 'undefined') {
      return __super_methodWithMapByteReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, string>}
   */
  this.methodWithMapCharacterReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapCharacterReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapCharacterReturn != 'undefined') {
      return __super_methodWithMapCharacterReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, boolean>}
   */
  this.methodWithMapBooleanReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapBooleanReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapBooleanReturn != 'undefined') {
      return __super_methodWithMapBooleanReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, number>}
   */
  this.methodWithMapFloatReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapFloatReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapFloatReturn != 'undefined') {
      return __super_methodWithMapFloatReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, number>}
   */
  this.methodWithMapDoubleReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapDoubleReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapDoubleReturn != 'undefined') {
      return __super_methodWithMapDoubleReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, Object>}
   */
  this.methodWithMapJsonObjectReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapJsonObjectReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapJsonObjectReturn != 'undefined') {
      return __super_methodWithMapJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, Object>}
   */
  this.methodWithMapComplexJsonObjectReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapComplexJsonObjectReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapComplexJsonObjectReturn != 'undefined') {
      return __super_methodWithMapComplexJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, Array>}
   */
  this.methodWithMapJsonArrayReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapJsonArrayReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapJsonArrayReturn != 'undefined') {
      return __super_methodWithMapJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, Array>}
   */
  this.methodWithMapComplexJsonArrayReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapComplexJsonArrayReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapComplexJsonArrayReturn != 'undefined') {
      return __super_methodWithMapComplexJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param handler {function} 
   @return {Object.<string, Object>}
   */
  this.methodWithMapObjectReturn =  function(handler) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      return utils.convReturnMap(j_collectionTCK["methodWithMapObjectReturn(io.vertx.core.Handler)"](function(jVal) {
        __args[0](jVal);
      })) ;
    } else if (typeof __super_methodWithMapObjectReturn != 'undefined') {
      return __super_methodWithMapObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.methodWithListStringReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return j_collectionTCK["methodWithListStringReturn()"]() ;
    } else if (typeof __super_methodWithListStringReturn != 'undefined') {
      return __super_methodWithListStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithListLongReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetLong(j_collectionTCK["methodWithListLongReturn()"]()) ;
    } else if (typeof __super_methodWithListLongReturn != 'undefined') {
      return __super_methodWithListLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<RefedInterface1>}
   */
  this.methodWithListVertxGenReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_collectionTCK["methodWithListVertxGenReturn()"](), RefedInterface1) ;
    } else if (typeof __super_methodWithListVertxGenReturn != 'undefined') {
      return __super_methodWithListVertxGenReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithListJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithListJsonObjectReturn != 'undefined') {
      return __super_methodWithListJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListComplexJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithListComplexJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithListComplexJsonObjectReturn != 'undefined') {
      return __super_methodWithListComplexJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Array>}
   */
  this.methodWithListJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithListJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithListJsonArrayReturn != 'undefined') {
      return __super_methodWithListJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Array>}
   */
  this.methodWithListComplexJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithListComplexJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithListComplexJsonArrayReturn != 'undefined') {
      return __super_methodWithListComplexJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListDataObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetDataObject(j_collectionTCK["methodWithListDataObjectReturn()"]()) ;
    } else if (typeof __super_methodWithListDataObjectReturn != 'undefined') {
      return __super_methodWithListDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListEnumReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetEnum(j_collectionTCK["methodWithListEnumReturn()"]()) ;
    } else if (typeof __super_methodWithListEnumReturn != 'undefined') {
      return __super_methodWithListEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithListObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetObject(j_collectionTCK["methodWithListObjectReturn()"]()) ;
    } else if (typeof __super_methodWithListObjectReturn != 'undefined') {
      return __super_methodWithListObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<string>}
   */
  this.methodWithSetStringReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnSet(j_collectionTCK["methodWithSetStringReturn()"]()) ;
    } else if (typeof __super_methodWithSetStringReturn != 'undefined') {
      return __super_methodWithSetStringReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<number>}
   */
  this.methodWithSetLongReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetLong(j_collectionTCK["methodWithSetLongReturn()"]()) ;
    } else if (typeof __super_methodWithSetLongReturn != 'undefined') {
      return __super_methodWithSetLongReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<RefedInterface1>}
   */
  this.methodWithSetVertxGenReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetVertxGen(j_collectionTCK["methodWithSetVertxGenReturn()"](), RefedInterface1) ;
    } else if (typeof __super_methodWithSetVertxGenReturn != 'undefined') {
      return __super_methodWithSetVertxGenReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithSetJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithSetJsonObjectReturn != 'undefined') {
      return __super_methodWithSetJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetComplexJsonObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithSetComplexJsonObjectReturn()"]()) ;
    } else if (typeof __super_methodWithSetComplexJsonObjectReturn != 'undefined') {
      return __super_methodWithSetComplexJsonObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Array>}
   */
  this.methodWithSetJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithSetJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithSetJsonArrayReturn != 'undefined') {
      return __super_methodWithSetJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Array>}
   */
  this.methodWithSetComplexJsonArrayReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetJson(j_collectionTCK["methodWithSetComplexJsonArrayReturn()"]()) ;
    } else if (typeof __super_methodWithSetComplexJsonArrayReturn != 'undefined') {
      return __super_methodWithSetComplexJsonArrayReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetDataObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetDataObject(j_collectionTCK["methodWithSetDataObjectReturn()"]()) ;
    } else if (typeof __super_methodWithSetDataObjectReturn != 'undefined') {
      return __super_methodWithSetDataObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetEnumReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetEnum(j_collectionTCK["methodWithSetEnumReturn()"]()) ;
    } else if (typeof __super_methodWithSetEnumReturn != 'undefined') {
      return __super_methodWithSetEnumReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   @return {Array.<Object>}
   */
  this.methodWithSetObjectReturn =  function() {
    var __args = arguments;
    if (__args.length === 0) {
      return utils.convReturnListSetObject(j_collectionTCK["methodWithSetObjectReturn()"]()) ;
    } else if (typeof __super_methodWithSetObjectReturn != 'undefined') {
      return __super_methodWithSetObjectReturn.apply(this, __args);
    }
    else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_collectionTCK;
};

CollectionTCK._jclass = utils.getJavaClass("io.vertx.codegen.testmodel.CollectionTCK");
CollectionTCK._jtype = {accept: function(obj) {
    return CollectionTCK._jclass.isInstance(obj._jdel);
  },wrap: function(jdel) {
    var obj = Object.create(CollectionTCK.prototype, {});
    CollectionTCK.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
CollectionTCK._create = function(jdel) {var obj = Object.create(CollectionTCK.prototype, {});
  CollectionTCK.apply(obj, arguments);
  return obj;
}
module.exports = CollectionTCK;