/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.IntervalConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class Interval {
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private int microseconds;

    public Interval() {
        this(0, 0, 0, 0, 0, 0, 0);
    }

    public Interval(int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.microseconds = microseconds;
    }

    public Interval(int years, int months, int days, int hours, int minutes, int seconds) {
        this(years, months, days, hours, minutes, seconds, 0);
    }

    public Interval(int years, int months, int days, int hours, int minutes) {
        this(years, months, days, hours, minutes, 0);
    }

    public Interval(int years, int months, int days, int hours) {
        this(years, months, days, hours, 0);
    }

    public Interval(int years, int months, int days) {
        this(years, months, days, 0);
    }

    public Interval(int years, int months) {
        this(years, months, 0);
    }

    public Interval(int years) {
        this(years, 0);
    }

    public Interval(JsonObject json) {
        IntervalConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public static Interval of() {
        return new Interval();
    }

    public static Interval of(int years, int months, int days, int hours, int minutes, int seconds, int microseconds) {
        return new Interval(years, months, days, hours, minutes, seconds, microseconds);
    }

    public static Interval of(int years, int months, int days, int hours, int minutes, int seconds) {
        return new Interval(years, months, days, hours, minutes, seconds);
    }

    public static Interval of(int years, int months, int days, int hours, int minutes) {
        return new Interval(years, months, days, hours, minutes);
    }

    public static Interval of(int years, int months, int days, int hours) {
        return new Interval(years, months, days, hours);
    }

    public static Interval of(int years, int months, int days) {
        return new Interval(years, months, days);
    }

    public static Interval of(int years, int months) {
        return new Interval(years, months);
    }

    public static Interval of(int years) {
        return new Interval(years);
    }

    public Interval years(int years) {
        this.years = years;
        return this;
    }

    public Interval months(int months) {
        this.months = months;
        return this;
    }

    public Interval days(int days) {
        this.days = days;
        return this;
    }

    public Interval hours(int hours) {
        this.hours = hours;
        return this;
    }

    public Interval minutes(int minutes) {
        this.minutes = minutes;
        return this;
    }

    public Interval seconds(int seconds) {
        this.seconds = seconds;
        return this;
    }

    public Interval microseconds(int microseconds) {
        this.microseconds = microseconds;
        return this;
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public int getMicroseconds() {
        return this.microseconds;
    }

    public void setMicroseconds(int microseconds) {
        this.microseconds = microseconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return this.years == interval.years && this.months == interval.months && this.days == interval.days && this.hours == interval.hours && this.minutes == interval.minutes && this.seconds == interval.seconds && this.microseconds == interval.microseconds;
    }

    public int hashCode() {
        int result = this.years;
        result = 31 * result + this.months;
        result = 31 * result + this.days;
        result = 31 * result + this.hours;
        result = 31 * result + this.minutes;
        result = 31 * result + this.seconds;
        result = 31 * result + this.microseconds;
        return result;
    }

    public String toString() {
        return "Interval( " + this.years + " years " + this.months + " months " + this.days + " days " + this.hours + " hours " + this.minutes + " minutes " + this.seconds + (this.microseconds == 0 ? "" : "." + Math.abs(this.microseconds)) + " seconds )";
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        IntervalConverter.toJson(this, json);
        return json;
    }
}

