/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgConnection;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;

public class PgConnectionImpl
extends SqlConnectionImpl<PgConnectionImpl>
implements PgConnection {
    private final PgConnectionFactory factory;
    private volatile Handler<PgNotification> notificationHandler;

    public static void connect(Vertx vertx, PgConnectOptions options, Handler<AsyncResult<PgConnection>> handler) {
        Context ctx = Vertx.currentContext();
        if (ctx != null) {
            PgConnectionFactory client = new PgConnectionFactory(ctx, false, options);
            client.connectAndInit((Handler<AsyncResult<Connection>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    Connection conn = (Connection)ar.result();
                    PgConnectionImpl p = new PgConnectionImpl(client, ctx, conn);
                    conn.init((Connection.Holder)p);
                    handler.handle((Object)Future.succeededFuture((Object)p));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        } else {
            vertx.runOnContext(v -> {
                if (options.isUsingDomainSocket() && !vertx.isNativeTransportEnabled()) {
                    handler.handle((Object)Future.failedFuture((String)"Native transport is not available"));
                } else {
                    PgConnectionImpl.connect(vertx, options, handler);
                }
            });
        }
    }

    public PgConnectionImpl(PgConnectionFactory factory, Context context, Connection conn) {
        super(context, conn);
        this.factory = factory;
    }

    @Override
    public PgConnection notificationHandler(Handler<PgNotification> handler) {
        this.notificationHandler = handler;
        return this;
    }

    public void handleNotification(int processId, String channel, String payload) {
        Handler<PgNotification> handler = this.notificationHandler;
        if (handler != null) {
            handler.handle((Object)new PgNotification().setProcessId(processId).setChannel(channel).setPayload(payload));
        }
    }

    @Override
    public int processId() {
        return this.conn.getProcessId();
    }

    @Override
    public int secretKey() {
        return this.conn.getSecretKey();
    }

    @Override
    public PgConnection cancelRequest(Handler<AsyncResult<Void>> handler) {
        Context current = Vertx.currentContext();
        if (current == this.context) {
            this.factory.connect((Handler<AsyncResult<PgSocketConnection>>)((Handler)ar -> {
                if (ar.succeeded()) {
                    PgSocketConnection conn = (PgSocketConnection)((Object)((Object)ar.result()));
                    conn.sendCancelRequestMessage(this.processId(), this.secretKey(), handler);
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }));
        } else {
            this.context.runOnContext(v -> this.cancelRequest(handler));
        }
        return this;
    }
}

