/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgNotification;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collector;

@VertxGen
public interface PgConnection
extends SqlConnection {
    public static void connect(Vertx vertx, PgConnectOptions options, Handler<AsyncResult<PgConnection>> handler) {
        PgConnectionImpl.connect(vertx, options, handler);
    }

    public static void connect(Vertx vertx, Handler<AsyncResult<PgConnection>> handler) {
        PgConnection.connect(vertx, PgConnectOptions.fromEnv(), handler);
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<PgConnection>> handler) {
        PgConnection.connect(vertx, PgConnectOptions.fromUri(connectionUri), handler);
    }

    @Fluent
    public PgConnection notificationHandler(Handler<PgNotification> var1);

    public PgConnection cancelRequest(Handler<AsyncResult<Void>> var1);

    public int processId();

    public int secretKey();

    public PgConnection prepare(String var1, Handler<AsyncResult<PreparedQuery>> var2);

    public PgConnection exceptionHandler(Handler<Throwable> var1);

    public PgConnection closeHandler(Handler<Void> var1);

    public PgConnection preparedQuery(String var1, Handler<AsyncResult<RowSet>> var2);

    @GenIgnore
    public <R> PgConnection preparedQuery(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public PgConnection query(String var1, Handler<AsyncResult<RowSet>> var2);

    @GenIgnore
    public <R> PgConnection query(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public PgConnection preparedQuery(String var1, Tuple var2, Handler<AsyncResult<RowSet>> var3);

    @GenIgnore
    public <R> PgConnection preparedQuery(String var1, Tuple var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);

    public PgConnection preparedBatch(String var1, List<Tuple> var2, Handler<AsyncResult<RowSet>> var3);

    @GenIgnore
    public <R> PgConnection preparedBatch(String var1, List<Tuple> var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);
}

