/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import java.util.ArrayList;
import java.util.Map;

public class PathConverter
implements JsonCodec<Path, JsonObject> {
    public static final PathConverter INSTANCE = new PathConverter();

    public JsonObject encode(Path value) {
        return value != null ? value.toJson() : null;
    }

    public Path decode(JsonObject value) {
        return value != null ? new Path(value) : null;
    }

    public Class<Path> getTargetClass() {
        return Path.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, Path obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "open": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setOpen((Boolean)member.getValue());
                    break;
                }
                case "points": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Point> list = new ArrayList<Point>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Point((JsonObject)item));
                        }
                    });
                    obj.setPoints(list);
                }
            }
        }
    }

    public static void toJson(Path obj, JsonObject json) {
        PathConverter.toJson(obj, json.getMap());
    }

    public static void toJson(Path obj, Map<String, Object> json) {
        json.put("open", obj.isOpen());
        if (obj.getPoints() != null) {
            JsonArray array = new JsonArray();
            obj.getPoints().forEach(item -> array.add(item.toJson()));
            json.put("points", array);
        }
    }
}

