/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.json.JsonCodec;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import java.util.ArrayList;
import java.util.Map;

public class PolygonConverter
implements JsonCodec<Polygon, JsonObject> {
    public static final PolygonConverter INSTANCE = new PolygonConverter();

    public JsonObject encode(Polygon value) {
        return value != null ? value.toJson() : null;
    }

    public Polygon decode(JsonObject value) {
        return value != null ? new Polygon(value) : null;
    }

    public Class<Polygon> getTargetClass() {
        return Polygon.class;
    }

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, Polygon obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "points": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ArrayList<Point> list = new ArrayList<Point>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            list.add(new Point((JsonObject)item));
                        }
                    });
                    obj.setPoints(list);
                }
            }
        }
    }

    public static void toJson(Polygon obj, JsonObject json) {
        PolygonConverter.toJson(obj, json.getMap());
    }

    public static void toJson(Polygon obj, Map<String, Object> json) {
        if (obj.getPoints() != null) {
            JsonArray array = new JsonArray();
            obj.getPoints().forEach(item -> array.add(item.toJson()));
            json.put("points", array);
        }
    }
}

