/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.pgclient.impl.RowImpl;
import io.vertx.pgclient.impl.codec.DataFormat;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDecoder;
import java.util.function.BiConsumer;
import java.util.stream.Collector;

class RowResultDecoder<C, R>
implements RowDecoder {
    final Collector<Row, C, R> collector;
    final boolean singleton;
    final BiConsumer<C, Row> accumulator;
    final PgRowDesc desc;
    private int size;
    private C container;
    private Row row;

    RowResultDecoder(Collector<Row, C, R> collector, boolean singleton, PgRowDesc desc) {
        this.collector = collector;
        this.singleton = singleton;
        this.accumulator = collector.accumulator();
        this.desc = desc;
    }

    public int size() {
        return this.size;
    }

    public void decodeRow(int len, ByteBuf in) {
        if (this.container == null) {
            this.container = this.collector.supplier().get();
        }
        if (this.singleton) {
            if (this.row == null) {
                this.row = new RowImpl(this.desc);
            } else {
                this.row.clear();
            }
        } else {
            this.row = new RowImpl(this.desc);
        }
        RowImpl row = new RowImpl(this.desc);
        for (int c = 0; c < len; ++c) {
            int length = in.readInt();
            Object decoded = null;
            if (length != -1) {
                PgColumnDesc columnDesc = this.desc.columns[c];
                decoded = columnDesc.dataFormat == DataFormat.BINARY ? DataTypeCodec.decodeBinary(columnDesc.dataType, in.readerIndex(), length, in) : DataTypeCodec.decodeText(columnDesc.dataType, in.readerIndex(), length, in);
                in.skipBytes(length);
            }
            row.addValue(decoded);
        }
        this.accumulator.accept(this.container, (Row)row);
        ++this.size;
    }

    R complete() {
        if (this.container == null) {
            this.container = this.collector.supplier().get();
        }
        return this.collector.finisher().apply(this.container);
    }

    void reset() {
        this.container = null;
        this.size = 0;
    }
}

