/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.util;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Util {
    private static final byte ZERO = 0;
    private static final int FIRST_HALF_BYTE_MASK = 15;

    public static String readCString(ByteBuf src, Charset charset) {
        int len = src.bytesBefore((byte)0);
        String s = src.readCharSequence(len, charset).toString();
        src.readByte();
        return s;
    }

    public static String readCStringUTF8(ByteBuf src) {
        int len = src.bytesBefore((byte)0);
        String s = src.readCharSequence(len, StandardCharsets.UTF_8).toString();
        src.readByte();
        return s;
    }

    public static void writeCString(ByteBuf dst, String s, Charset charset) {
        dst.writeCharSequence((CharSequence)s, charset);
        dst.writeByte(0);
    }

    public static void writeCString(ByteBuf dst, ByteBuf buf) {
        dst.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        dst.writeByte(0);
    }

    public static void writeCStringUTF8(ByteBuf dst, String s) {
        dst.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
        dst.writeByte(0);
    }

    public static void writeCString(ByteBuf dst, byte[] bytes) {
        dst.writeBytes(bytes, 0, bytes.length);
        dst.writeByte(0);
    }

    public static String buildInvalidArgsError(Stream<Object> values, Stream<Class> types) {
        return "Values [" + values.map(String::valueOf).collect(Collectors.joining(", ")) + "] cannot be coerced to [" + types.map(Class::getSimpleName).collect(Collectors.joining(", ")) + "]";
    }

    public static int writeHexString(Buffer buffer, ByteBuf to) {
        int len = buffer.length();
        for (int i = 0; i < len; ++i) {
            int b = Byte.toUnsignedInt(buffer.getByte(i));
            int firstDigit = b >> 4;
            byte firstHexDigit = (byte)Util.bin2hex(firstDigit);
            int secondDigit = b & 0xF;
            byte secondHexDigit = (byte)Util.bin2hex(secondDigit);
            to.writeByte((int)firstHexDigit);
            to.writeByte((int)secondHexDigit);
        }
        return len;
    }

    private static int bin2hex(int digit) {
        int isLessOrEqual9 = digit - 10 >> 31;
        int bin2hexAsciiDistance = 48 + (~isLessOrEqual9 & 0x27);
        return digit + bin2hexAsciiDistance;
    }
}

