/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.amqpbridge;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Vert.x AMQP Bridge. Facilitates sending and receiving AMQP 1.0 messages.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.amqpbridge.AmqpBridge original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.amqpbridge.AmqpBridge.class)
public class AmqpBridge {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AmqpBridge that = (AmqpBridge) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AmqpBridge> __TYPE_ARG = new TypeArg<>(    obj -> new AmqpBridge((io.vertx.amqpbridge.AmqpBridge) obj),
    AmqpBridge::getDelegate
  );

  private final io.vertx.amqpbridge.AmqpBridge delegate;
  
  public AmqpBridge(io.vertx.amqpbridge.AmqpBridge delegate) {
    this.delegate = delegate;
  }

  public AmqpBridge(Object delegate) {
    this.delegate = (io.vertx.amqpbridge.AmqpBridge)delegate;
  }

  public io.vertx.amqpbridge.AmqpBridge getDelegate() {
    return delegate;
  }


  /**
   * Creates a Bridge.
   * @param vertx the vertx instance to use
   * @return the (not-yet-started) bridge.
   */
  public static io.vertx.rxjava.amqpbridge.AmqpBridge create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.amqpbridge.AmqpBridge ret = io.vertx.rxjava.amqpbridge.AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)io.vertx.amqpbridge.AmqpBridge.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Creates a Bridge with the given options.
   * @param vertx the vertx instance to use
   * @param options the options
   * @return the (not-yet-started) bridge.
   */
  public static io.vertx.rxjava.amqpbridge.AmqpBridge create(io.vertx.rxjava.core.Vertx vertx, io.vertx.amqpbridge.AmqpBridgeOptions options) { 
    io.vertx.rxjava.amqpbridge.AmqpBridge ret = io.vertx.rxjava.amqpbridge.AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)io.vertx.amqpbridge.AmqpBridge.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Starts the bridge, establishing the underlying connection.
   * @param hostname the host name to connect to
   * @param port the port to connect to
   * @param username the username
   * @param password the password
   * @param resultHandler the result handler
   */
  public void start(String hostname, int port, String username, String password, Handler<AsyncResult<io.vertx.rxjava.amqpbridge.AmqpBridge>> resultHandler) { 
    delegate.start(hostname, port, username, password, new Handler<AsyncResult<io.vertx.amqpbridge.AmqpBridge>>() {
      public void handle(AsyncResult<io.vertx.amqpbridge.AmqpBridge> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqpbridge.AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Starts the bridge, establishing the underlying connection.
   * @param hostname the host name to connect to
   * @param port the port to connect to
   * @param username the username
   * @param password the password
   * @return 
   * @deprecated use {@link #rxStart} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.amqpbridge.AmqpBridge> startObservable(String hostname, int port, String username, String password) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.amqpbridge.AmqpBridge> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    start(hostname, port, username, password, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Starts the bridge, establishing the underlying connection.
   * @param hostname the host name to connect to
   * @param port the port to connect to
   * @param username the username
   * @param password the password
   * @return 
   */
  public Single<io.vertx.rxjava.amqpbridge.AmqpBridge> rxStart(String hostname, int port, String username, String password) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      start(hostname, port, username, password, fut);
    }));
  }

  /**
   * Starts the bridge, establishing the underlying connection.
   * @param hostname the host name to connect to
   * @param port the port to connect to
   * @param resultHandler the result handler
   */
  public void start(String hostname, int port, Handler<AsyncResult<io.vertx.rxjava.amqpbridge.AmqpBridge>> resultHandler) { 
    delegate.start(hostname, port, new Handler<AsyncResult<io.vertx.amqpbridge.AmqpBridge>>() {
      public void handle(AsyncResult<io.vertx.amqpbridge.AmqpBridge> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.amqpbridge.AmqpBridge.newInstance((io.vertx.amqpbridge.AmqpBridge)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Starts the bridge, establishing the underlying connection.
   * @param hostname the host name to connect to
   * @param port the port to connect to
   * @return 
   * @deprecated use {@link #rxStart} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.amqpbridge.AmqpBridge> startObservable(String hostname, int port) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.amqpbridge.AmqpBridge> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    start(hostname, port, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Starts the bridge, establishing the underlying connection.
   * @param hostname the host name to connect to
   * @param port the port to connect to
   * @return 
   */
  public Single<io.vertx.rxjava.amqpbridge.AmqpBridge> rxStart(String hostname, int port) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      start(hostname, port, fut);
    }));
  }

  /**
   * Creates a consumer on the given AMQP address.
   *
   * This method MUST be called from the bridge Context thread, as used in the result handler callback from the start
   * methods. The bridge MUST be successfully started before the method is called.
   * @param amqpAddress the address to consume from
   * @return the consumer
   */
  public <T> io.vertx.rxjava.core.eventbus.MessageConsumer<T> createConsumer(String amqpAddress) { 
    io.vertx.rxjava.core.eventbus.MessageConsumer<T> ret = io.vertx.rxjava.core.eventbus.MessageConsumer.newInstance((io.vertx.core.eventbus.MessageConsumer)delegate.createConsumer(amqpAddress), TypeArg.unknown());
    return ret;
  }

  /**
   * Creates a producer to the given AMQP address.
   *
   * This method MUST be called from the bridge Context thread, as used in the result handler callback from the start
   * methods. The bridge MUST be successfully started before the method is called.
   * @param amqpAddress the address to produce to
   * @return the producer
   */
  public <T> io.vertx.rxjava.core.eventbus.MessageProducer<T> createProducer(String amqpAddress) { 
    io.vertx.rxjava.core.eventbus.MessageProducer<T> ret = io.vertx.rxjava.core.eventbus.MessageProducer.newInstance((io.vertx.core.eventbus.MessageProducer)delegate.createProducer(amqpAddress), TypeArg.unknown());
    return ret;
  }

  /**
   * Shuts the bridge down, closing the underlying connection.
   * @param resultHandler the result handler
   */
  public void close(Handler<AsyncResult<Void>> resultHandler) { 
    delegate.close(resultHandler);
  }

    /**
   * Shuts the bridge down, closing the underlying connection.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    close(resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Shuts the bridge down, closing the underlying connection.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Set an end handler. This will fire if the underlying connection is unexpectedly disconnected or remotely closed.
   * @param endHandler the handler
   */
  public void endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
  }

  public static AmqpBridge newInstance(io.vertx.amqpbridge.AmqpBridge arg) {
    return arg != null ? new AmqpBridge(arg) : null;
  }

}
