/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.config;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Defines a configuration retriever that read configuration from
 * 
 * and tracks changes periodically.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.config.ConfigRetriever original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.config.ConfigRetriever.class)
public class ConfigRetriever {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ConfigRetriever that = (ConfigRetriever) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ConfigRetriever> __TYPE_ARG = new TypeArg<>(    obj -> new ConfigRetriever((io.vertx.config.ConfigRetriever) obj),
    ConfigRetriever::getDelegate
  );

  private final io.vertx.config.ConfigRetriever delegate;
  
  public ConfigRetriever(io.vertx.config.ConfigRetriever delegate) {
    this.delegate = delegate;
  }

  public ConfigRetriever(Object delegate) {
    this.delegate = (io.vertx.config.ConfigRetriever)delegate;
  }

  public io.vertx.config.ConfigRetriever getDelegate() {
    return delegate;
  }


  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.config.ConfigRetriever}.
   * @param vertx the vert.x instance
   * @param options the options, must not be <code>null</code>, must contain the list of configured store.
   * @return the created instance.
   */
  public static io.vertx.rxjava.config.ConfigRetriever create(io.vertx.rxjava.core.Vertx vertx, io.vertx.config.ConfigRetrieverOptions options) { 
    io.vertx.rxjava.config.ConfigRetriever ret = io.vertx.rxjava.config.ConfigRetriever.newInstance((io.vertx.config.ConfigRetriever)io.vertx.config.ConfigRetriever.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Creates an instance of the default implementation of the {@link io.vertx.rxjava.config.ConfigRetriever}, using the default
   * settings (json file, system properties and environment variables).
   * @param vertx the vert.x instance
   * @return the created instance.
   */
  public static io.vertx.rxjava.config.ConfigRetriever create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.config.ConfigRetriever ret = io.vertx.rxjava.config.ConfigRetriever.newInstance((io.vertx.config.ConfigRetriever)io.vertx.config.ConfigRetriever.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava.config.ConfigRetriever#getConfig}, but returning a  object. The result is a
   * .
   * @param retriever the config retrieve
   * @return the future completed when the configuration is retrieved
   */
  @Deprecated()
  public static io.vertx.rxjava.core.Future<JsonObject> getConfigAsFuture(io.vertx.rxjava.config.ConfigRetriever retriever) { 
    io.vertx.rxjava.core.Future<JsonObject> ret = io.vertx.rxjava.core.Future.newInstance((io.vertx.core.Future)io.vertx.config.ConfigRetriever.getConfigAsFuture(retriever.getDelegate()), TypeArg.unknown());
    return ret;
  }

  /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * @param completionHandler handler receiving the computed configuration, or a failure if the configuration cannot be retrieved
   */
  public void getConfig(Handler<AsyncResult<JsonObject>> completionHandler) { 
    delegate.getConfig(completionHandler);
  }

    /**
   * Reads the configuration from the different 
   * and computes the final configuration.
   * @return 
   */
  public Single<JsonObject> rxGetConfig() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getConfig(fut);
    }));
  }

  /**
   * Closes the retriever.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Gets the last computed configuration.
   * @return the last configuration
   */
  public JsonObject getCachedConfig() { 
    JsonObject ret = delegate.getCachedConfig();
    return ret;
  }

  /**
   * Registers a listener receiving configuration changes. This method cannot only be called if
   * the configuration is broadcasted.
   * @param listener the listener
   */
  public void listen(Handler<io.vertx.config.ConfigChange> listener) { 
    delegate.listen(listener);
  }

  /**
   * Registers a handler called before every scan. This method is mostly used for logging purpose.
   * @param function the function, must not be <code>null</code>
   * @return the current config retriever
   */
  public io.vertx.rxjava.config.ConfigRetriever setBeforeScanHandler(Handler<Void> function) { 
    delegate.setBeforeScanHandler(function);
    return this;
  }

  /**
   * Registers a handler that process the configuration before being injected into {@link io.vertx.rxjava.config.ConfigRetriever#getConfig} or {@link io.vertx.rxjava.config.ConfigRetriever#listen}. This allows
   * the code to customize the configuration.
   * @param processor the processor, must not be <code>null</code>. The method must not return <code>null</code>. The returned configuration is used. If the processor does not update the configuration, it must return the input configuration. If the processor throws an exception, the failure is passed to the {@link io.vertx.rxjava.config.ConfigRetriever#getConfig} handler.
   * @return the current config retriever
   */
  public io.vertx.rxjava.config.ConfigRetriever setConfigurationProcessor(Function<JsonObject, JsonObject> processor) { 
    delegate.setConfigurationProcessor(processor);
    return this;
  }

  /**
   * @return the stream of configurations. It's single stream (unicast) and that delivers the last known config and the successors periodically.
   */
  public io.vertx.rxjava.core.streams.ReadStream<JsonObject> configStream() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.streams.ReadStream<JsonObject> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.configStream(), TypeArg.unknown());
    cached_0 = ret;
    return ret;
  }

  private io.vertx.rxjava.core.streams.ReadStream<JsonObject> cached_0;
  public static ConfigRetriever newInstance(io.vertx.config.ConfigRetriever arg) {
    return arg != null ? new ConfigRetriever(arg) : null;
  }

}
