/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A timeout stream is triggered by a timer, the {@link io.vertx.core.Handler} will be call when the timer is fired,
 * it can be once or several times depending on the nature of the timer related to this stream. The
 *  will be called after the timer handler has been called.
 * <p>
 * Pausing the timer inhibits the timer shots until the stream is resumed. Setting a null handler callback cancels
 * the timer.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.TimeoutStream original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.TimeoutStream.class)
public class TimeoutStream implements io.vertx.rxjava.core.streams.ReadStream<Long> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TimeoutStream that = (TimeoutStream) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TimeoutStream> __TYPE_ARG = new TypeArg<>(    obj -> new TimeoutStream((io.vertx.core.TimeoutStream) obj),
    TimeoutStream::getDelegate
  );

  private final io.vertx.core.TimeoutStream delegate;
  
  public TimeoutStream(io.vertx.core.TimeoutStream delegate) {
    this.delegate = delegate;
  }

  public TimeoutStream(Object delegate) {
    this.delegate = (io.vertx.core.TimeoutStream)delegate;
  }

  public io.vertx.core.TimeoutStream getDelegate() {
    return delegate;
  }

  private Observable<Long> observable;

  public synchronized Observable<Long> toObservable() {
    if (observable == null) {
      observable = RxHelper.toObservable(this.getDelegate());
    }
    return observable;
  }


  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<Long> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<Long> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TypeArg.unknown());
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<Long> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<Long> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   * @deprecated use {@link #rxPipeTo} instead
   */
  @Deprecated()
  public Observable<Void> pipeToObservable(io.vertx.rxjava.core.streams.WriteStream<Long> dst) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pipeTo(dst, handler.toHandler());
    return handler;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<Long> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public io.vertx.rxjava.core.TimeoutStream exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.core.TimeoutStream handler(Handler<Long> handler) { 
    delegate.handler(handler);
    return this;
  }

  public io.vertx.rxjava.core.TimeoutStream pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.TimeoutStream resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.TimeoutStream fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.core.TimeoutStream endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  /**
   * Cancels the timeout. Note this has the same effect as calling {@link io.vertx.rxjava.core.TimeoutStream#handler} with a null
   * argument.
   */
  public void cancel() { 
    delegate.cancel();
  }

  public static TimeoutStream newInstance(io.vertx.core.TimeoutStream arg) {
    return arg != null ? new TimeoutStream(arg) : null;
  }

}
