/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.file;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents properties of the file system.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.file.FileSystemProps original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.file.FileSystemProps.class)
public class FileSystemProps {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileSystemProps that = (FileSystemProps) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<FileSystemProps> __TYPE_ARG = new TypeArg<>(    obj -> new FileSystemProps((io.vertx.core.file.FileSystemProps) obj),
    FileSystemProps::getDelegate
  );

  private final io.vertx.core.file.FileSystemProps delegate;
  
  public FileSystemProps(io.vertx.core.file.FileSystemProps delegate) {
    this.delegate = delegate;
  }

  public FileSystemProps(Object delegate) {
    this.delegate = (io.vertx.core.file.FileSystemProps)delegate;
  }

  public io.vertx.core.file.FileSystemProps getDelegate() {
    return delegate;
  }

  /**
   * @return The total space on the file system, in bytes
   */
  public long totalSpace() { 
    long ret = delegate.totalSpace();
    return ret;
  }

  /**
   * @return The total un-allocated space on the file system, in bytes
   */
  public long unallocatedSpace() { 
    long ret = delegate.unallocatedSpace();
    return ret;
  }

  /**
   * @return The total usable space on the file system, in bytes
   */
  public long usableSpace() { 
    long ret = delegate.usableSpace();
    return ret;
  }

  public static FileSystemProps newInstance(io.vertx.core.file.FileSystemProps arg) {
    return arg != null ? new FileSystemProps(arg) : null;
  }

}
