/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.http;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Base WebSocket implementation.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.rxjava.core.streams.Pipe} to pipe data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.WebSocketBase original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.http.WebSocketBase.class)
public interface WebSocketBase extends io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer>, io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> {

  io.vertx.core.http.WebSocketBase getDelegate();

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler);

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.WebSocketBase#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull();

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe();

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst);

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler);

  public io.vertx.rxjava.core.http.WebSocketBase exceptionHandler(Handler<java.lang.Throwable> handler);

  public io.vertx.rxjava.core.http.WebSocketBase handler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler);

  public io.vertx.rxjava.core.http.WebSocketBase pause();

  public io.vertx.rxjava.core.http.WebSocketBase resume();

  public io.vertx.rxjava.core.http.WebSocketBase fetch(long amount);

  public io.vertx.rxjava.core.http.WebSocketBase endHandler(Handler<Void> endHandler);

  public io.vertx.rxjava.core.http.WebSocketBase write(io.vertx.rxjava.core.buffer.Buffer data);

  public io.vertx.rxjava.core.http.WebSocketBase write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler);

  public io.vertx.rxjava.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize);

  public io.vertx.rxjava.core.http.WebSocketBase drainHandler(Handler<Void> handler);

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID();

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID();

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public String subProtocol();

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public Short closeStatusCode();

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public String closeReason();

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.rxjava.core.MultiMap headers();

  /**
   * Write a WebSocket frame to the connection
   * @param frame the frame to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler);

  /**
   * Write a final WebSocket text frame to the connection
   * @param text The text to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(String text);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler);

  /**
   * Write a final WebSocket binary frame to the connection
   * @param data The data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler);

  /**
   * Writes a (potentially large) piece of binary data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler);

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(String text);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(String text, Handler<AsyncResult<Void>> handler);

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data);

  /**
   * Set a close handler. This will be called when the WebSocket is closed.
   * <p/>
   * After this callback, no more messages are expected. When the WebSocket received a close frame, the
   * {@link io.vertx.rxjava.core.http.WebSocketBase#closeStatusCode} will return the status code and {@link io.vertx.rxjava.core.http.WebSocketBase#closeReason} will return the reason.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase closeHandler(Handler<Void> handler);

  /**
   * Set a frame handler on the connection. This handler will be called when frames are read on the connection.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase frameHandler(Handler<io.vertx.rxjava.core.http.WebSocketFrame> handler);

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase textMessageHandler(Handler<String> handler);

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.WebSocketBase#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase binaryMessageHandler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler);

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase pongHandler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler);

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end();

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler);

  /**
   * Close the WebSocket sending the default close frame.
   * <p/>
   * No more messages can be sent.
   */
  public void close();

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler);

  /**
   * Close the WebSocket sending a close frame with specified status code. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   */
  public void close(short statusCode);

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  public void close(short statusCode, Handler<AsyncResult<Void>> handler);

  /**
   * Close sending a close frame with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   * @param reason reason of closure
   */
  public void close(short statusCode, String reason);

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler);

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress();

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress();

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl();

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed();

  public static WebSocketBase newInstance(io.vertx.core.http.WebSocketBase arg) {
    return arg != null ? new WebSocketBaseImpl(arg) : null;
  }

}

class WebSocketBaseImpl implements WebSocketBase {
  private final io.vertx.core.http.WebSocketBase delegate;
  
  public WebSocketBaseImpl(io.vertx.core.http.WebSocketBase delegate) {
    this.delegate = delegate;
  }

  public WebSocketBaseImpl(Object delegate) {
    this.delegate = (io.vertx.core.http.WebSocketBase)delegate;
  }

  public io.vertx.core.http.WebSocketBase getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;

  public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   * @deprecated use {@link #rxEnd} instead
   */
  @Deprecated()
  public Observable<Void> endObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    end(data, handler.toHandler());
    return handler;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.http.WebSocketBase#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   * @deprecated use {@link #rxPipeTo} instead
   */
  @Deprecated()
  public Observable<Void> pipeToObservable(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pipeTo(dst, handler.toHandler());
    return handler;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public io.vertx.rxjava.core.http.WebSocketBase exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase handler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase write(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase write(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(data.getDelegate(), handler);
    return this;
  }

    @Deprecated()
  public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    write(data, handler.toHandler());
    return handler;
  }

  public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(data, fut);
    }));
  }

  public io.vertx.rxjava.core.http.WebSocketBase setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava.core.http.WebSocketBase drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the event bus - the ID of that
   * handler is given by this method.
   * <p>
   * Given this ID, a different event loop can send a binary frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return the binary handler id
   */
  public String binaryHandlerID() { 
    String ret = delegate.binaryHandlerID();
    return ret;
  }

  /**
   * When a <code>WebSocket</code> is created it automatically registers an event handler with the eventbus, the ID of that
   * handler is given by <code>textHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a text frame to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other WebSockets which are owned by different event loops.
   * @return 
   */
  public String textHandlerID() { 
    String ret = delegate.textHandlerID();
    return ret;
  }

  /**
   * Returns the WebSocket sub protocol selected by the WebSocket handshake.
   * <p/>
   * On the server, the value will be <code>null</code> when the handler receives the websocket callback as the
   * handshake will not be completed yet.
   * @return 
   */
  public String subProtocol() { 
    String ret = delegate.subProtocol();
    return ret;
  }

  /**
   * Returns the close status code received from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public Short closeStatusCode() { 
    Short ret = delegate.closeStatusCode();
    return ret;
  }

  /**
   * Returns the close reason message from the remote endpoint or <code>null</code> when not yet received.
   * @return 
   */
  public String closeReason() { 
    String ret = delegate.closeReason();
    return ret;
  }

  /**
   *  Returns the HTTP headers when the WebSocket is first obtained in the handler.
   *  <p/>
   *  The headers will be <code>null</code> on subsequent interactions.
   * @return the headers
   */
  public io.vertx.rxjava.core.MultiMap headers() { 
    io.vertx.rxjava.core.MultiMap ret = io.vertx.rxjava.core.MultiMap.newInstance((io.vertx.core.MultiMap)delegate.headers());
    return ret;
  }

  /**
   * Write a WebSocket frame to the connection
   * @param frame the frame to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame) { 
    delegate.writeFrame(frame.getDelegate());
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFrame(io.vertx.rxjava.core.http.WebSocketFrame frame, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFrame(frame.getDelegate(), handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @return 
   * @deprecated use {@link #rxWriteFrame} instead
   */
  @Deprecated()
  public Observable<Void> writeFrameObservable(io.vertx.rxjava.core.http.WebSocketFrame frame) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    writeFrame(frame, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFrame} but with an <code>handler</code> called when the operation completes
   * @param frame 
   * @return 
   */
  public Single<Void> rxWriteFrame(io.vertx.rxjava.core.http.WebSocketFrame frame) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      writeFrame(frame, fut);
    }));
  }

  /**
   * Write a final WebSocket text frame to the connection
   * @param text The text to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(String text) { 
    delegate.writeFinalTextFrame(text);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalTextFrame(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalTextFrame(text, handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   * @deprecated use {@link #rxWriteFinalTextFrame} instead
   */
  @Deprecated()
  public Observable<Void> writeFinalTextFrameObservable(String text) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    writeFinalTextFrame(text, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalTextFrame} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public Single<Void> rxWriteFinalTextFrame(String text) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      writeFinalTextFrame(text, fut);
    }));
  }

  /**
   * Write a final WebSocket binary frame to the connection
   * @param data The data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.writeFinalBinaryFrame(data.getDelegate());
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeFinalBinaryFrame(data.getDelegate(), handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   * @deprecated use {@link #rxWriteFinalBinaryFrame} instead
   */
  @Deprecated()
  public Observable<Void> writeFinalBinaryFrameObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    writeFinalBinaryFrame(data, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeFinalBinaryFrame} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Single<Void> rxWriteFinalBinaryFrame(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      writeFinalBinaryFrame(data, fut);
    }));
  }

  /**
   * Writes a (potentially large) piece of binary data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param data the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.writeBinaryMessage(data.getDelegate());
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.writeBinaryMessage(data.getDelegate(), handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   * @deprecated use {@link #rxWriteBinaryMessage} instead
   */
  @Deprecated()
  public Observable<Void> writeBinaryMessageObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    writeBinaryMessage(data, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeBinaryMessage} but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Single<Void> rxWriteBinaryMessage(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      writeBinaryMessage(data, fut);
    }));
  }

  /**
   * Writes a (potentially large) piece of text data to the connection. This data might be written as multiple frames
   * if it exceeds the maximum WebSocket frame size.
   * @param text the data to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(String text) { 
    delegate.writeTextMessage(text);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.http.WebSocketBase writeTextMessage(String text, Handler<AsyncResult<Void>> handler) { 
    delegate.writeTextMessage(text, handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   * @deprecated use {@link #rxWriteTextMessage} instead
   */
  @Deprecated()
  public Observable<Void> writeTextMessageObservable(String text) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    writeTextMessage(text, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#writeTextMessage} but with an <code>handler</code> called when the operation completes
   * @param text 
   * @return 
   */
  public Single<Void> rxWriteTextMessage(String text) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      writeTextMessage(text, fut);
    }));
  }

  /**
   * Writes a ping frame to the connection. This will be written in a single frame. Ping frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 Section <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no handler for ping frames because RFC 6455  clearly
   * states that the only response to a ping frame is a pong frame with identical contents.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePing(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.writePing(data.getDelegate());
    return this;
  }

  /**
   * Writes a pong frame to the connection. This will be written in a single frame. Pong frames may be at most 125 bytes (octets).
   * <p>
   * This method should not be used to write application data and should only be used for implementing a keep alive or
   * to ensure the client is still responsive, see RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a>.
   * <p>
   * There is no need to manually write a pong frame, as the server and client both handle responding to a ping from with a pong from
   * automatically and this is exposed to users. RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> states that pongs may be sent unsolicited in order
   * to implement a one way heartbeat.
   * @param data the data to write, may be at most 125 bytes
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase writePong(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.writePong(data.getDelegate());
    return this;
  }

  /**
   * Set a close handler. This will be called when the WebSocket is closed.
   * <p/>
   * After this callback, no more messages are expected. When the WebSocket received a close frame, the
   * {@link io.vertx.rxjava.core.http.WebSocketBase#closeStatusCode} will return the status code and {@link io.vertx.rxjava.core.http.WebSocketBase#closeReason} will return the reason.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Set a frame handler on the connection. This handler will be called when frames are read on the connection.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase frameHandler(Handler<io.vertx.rxjava.core.http.WebSocketFrame> handler) { 
    delegate.frameHandler(new Handler<io.vertx.core.http.WebSocketFrame>() {
      public void handle(io.vertx.core.http.WebSocketFrame event) {
        handler.handle(io.vertx.rxjava.core.http.WebSocketFrame.newInstance((io.vertx.core.http.WebSocketFrame)event));
      }
    });
    return this;
  }

  /**
   * Set a text message handler on the connection. This handler will be called similar to the
   * , but the buffer will be converted to a String first
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase textMessageHandler(Handler<String> handler) { 
    delegate.textMessageHandler(handler);
    return this;
  }

  /**
   * Set a binary message handler on the connection. This handler serves a similar purpose to {@link io.vertx.rxjava.core.http.WebSocketBase#handler}
   * except that if a message comes into the socket in multiple frames, the data from the frames will be aggregated
   * into a single buffer before calling the handler (using {@link io.vertx.rxjava.core.http.WebSocketFrame#isFinal} to find the boundaries).
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase binaryMessageHandler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.binaryMessageHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  /**
   * Set a pong frame handler on the connection.  This handler will be invoked every time a pong frame is received
   * on the server, and can be used by both clients and servers since the RFC 6455 <a href="https://tools.ietf.org/html/rfc6455#section-5.5.2">section 5.5.2</a> and <a href="https://tools.ietf.org/html/rfc6455#section-5.5.3">section 5.5.3</a> do not
   * specify whether the client or server sends a ping.
   * <p>
   * Pong frames may be at most 125 bytes (octets).
   * <p>
   * There is no ping handler since ping frames should immediately be responded to with a pong frame with identical content
   * <p>
   * Pong frames may be received unsolicited.
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.http.WebSocketBase pongHandler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.pongHandler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

    /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @return 
   * @deprecated use {@link #rxEnd} instead
   */
  @Deprecated()
  public Observable<Void> endObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    end(handler.toHandler());
    return handler;
  }

  /**
   * Calls {@link io.vertx.rxjava.core.http.WebSocketBase#close}
   * @return 
   */
  public Single<Void> rxEnd() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Close the WebSocket sending the default close frame.
   * <p/>
   * No more messages can be sent.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Close the WebSocket sending a close frame with specified status code. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   */
  public void close(short statusCode) { 
    delegate.close(statusCode);
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param handler 
   */
  public void close(short statusCode, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, handler);
  }

    /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable(short statusCode) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(statusCode, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.http.WebSocketBase#close} but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @return 
   */
  public Single<Void> rxClose(short statusCode) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(statusCode, fut);
    }));
  }

  /**
   * Close sending a close frame with specified status code and reason. You can give a look at various close payloads
   * here: RFC6455 <a href="https://tools.ietf.org/html/rfc6455#section-7.4.1">section 7.4.1</a>
   * <p/>
   * No more messages can be sent.
   * @param statusCode Status code
   * @param reason reason of closure
   */
  public void close(short statusCode, String reason) { 
    delegate.close(statusCode, reason);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @param handler 
   */
  public void close(short statusCode, String reason, Handler<AsyncResult<Void>> handler) { 
    delegate.close(statusCode, reason, handler);
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable(short statusCode, String reason) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(statusCode, reason, handler.toHandler());
    return handler;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param statusCode 
   * @param reason 
   * @return 
   */
  public Single<Void> rxClose(short statusCode, String reason) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(statusCode, reason, fut);
    }));
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * @return true if this {@link io.vertx.rxjava.core.http.HttpConnection} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * @return <code>true</code> if the WebSocket is closed
   */
  public boolean isClosed() { 
    boolean ret = delegate.isClosed();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.rxjava.core.net.SocketAddress cached_0;
  private io.vertx.rxjava.core.net.SocketAddress cached_1;
}
