/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a TCP server
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetServer.class)
public class NetServer implements io.vertx.rxjava.core.metrics.Measured {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetServer that = (NetServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetServer> __TYPE_ARG = new TypeArg<>(    obj -> new NetServer((io.vertx.core.net.NetServer) obj),
    NetServer::getDelegate
  );

  private final io.vertx.core.net.NetServer delegate;
  
  public NetServer(io.vertx.core.net.NetServer delegate) {
    this.delegate = delegate;
  }

  public NetServer(Object delegate) {
    this.delegate = (io.vertx.core.net.NetServer)delegate;
  }

  public io.vertx.core.net.NetServer getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.core.net.NetSocket> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.net.NetSocket>(o1 -> io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)o1), o1 -> o1.getDelegate());

  /**
   * Whether the metrics are enabled for this measured object
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Return the connect stream for this server. The server can only have at most one handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.rxjava.core.net.NetSocket} and passes it to the
   * connect stream .
   * @return the connect stream
   */
  public io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.net.NetSocket> connectStream() { 
    io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.net.NetSocket> ret = io.vertx.rxjava.core.streams.ReadStream.newInstance((io.vertx.core.streams.ReadStream)delegate.connectStream(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Supply a connect handler for this server. The server can only have at most one connect handler at any one time.
   * As the server accepts TCP or SSL connections it creates an instance of {@link io.vertx.rxjava.core.net.NetSocket} and passes it to the
   * connect handler.
   * @param handler 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer connectHandler(Handler<io.vertx.rxjava.core.net.NetSocket> handler) { 
    io.vertx.rxjava.core.net.NetServer ret = io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)delegate.connectHandler(new Handler<io.vertx.core.net.NetSocket>() {
      public void handle(io.vertx.core.net.NetSocket event) {
        handler.handle(io.vertx.rxjava.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event));
      }
    }));
    return ret;
  }

  /**
   * Start listening on the port and host as configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen() { 
    delegate.listen();
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(Handler<AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.net.NetServer> listenObservable() { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.net.NetServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.net.NetServer> rxListen() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(fut);
    }));
  }

  /**
   * Start listening on the specified port and host, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * Host <code>0.0.0.0</code> can be specified meaning "listen on all available interfaces".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @param host 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port, String host) { 
    delegate.listen(port, host);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port, String host, Handler<AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, host, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.net.NetServer> listenObservable(int port, String host) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.net.NetServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(port, host, listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param host the host to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.net.NetServer> rxListen(int port, String host) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(port, host, fut);
    }));
  }

  /**
   * Start listening on the specified port and host "0.0.0.0", ignoring port and host configured in the
   * {@link io.vertx.core.net.NetServerOptions} used when creating the server.
   * <p>
   * Port <code>0</code> can be specified meaning "choose an random port".
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param port 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port) { 
    delegate.listen(port);
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(int port, Handler<AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(port, new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.net.NetServer> listenObservable(int port) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.net.NetServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(port, listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param port the port to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.net.NetServer> rxListen(int port) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(port, fut);
    }));
  }

  /**
   * Start listening on the specified local address, ignoring port and host configured in the {@link io.vertx.core.net.NetServerOptions} used when
   * creating the server.
   * <p>
   * The server may not be listening until some time after the call to listen has returned.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(io.vertx.rxjava.core.net.SocketAddress localAddress) { 
    delegate.listen(localAddress.getDelegate());
    return this;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @param listenHandler handler that will be notified when listening or failed
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetServer listen(io.vertx.rxjava.core.net.SocketAddress localAddress, Handler<AsyncResult<io.vertx.rxjava.core.net.NetServer>> listenHandler) { 
    delegate.listen(localAddress.getDelegate(), new Handler<AsyncResult<io.vertx.core.net.NetServer>>() {
      public void handle(AsyncResult<io.vertx.core.net.NetServer> ar) {
        if (ar.succeeded()) {
          listenHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.core.net.NetServer.newInstance((io.vertx.core.net.NetServer)ar.result())));
        } else {
          listenHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.core.net.NetServer> listenObservable(io.vertx.rxjava.core.net.SocketAddress localAddress) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.core.net.NetServer> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(localAddress, listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#listen} but providing a handler that will be notified when the server is listening, or fails.
   * @param localAddress the local address to listen on
   * @return a reference to this, so the API can be used fluently
   */
  public Single<io.vertx.rxjava.core.net.NetServer> rxListen(io.vertx.rxjava.core.net.SocketAddress localAddress) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(localAddress, fut);
    }));
  }

  /**
   * Close the server. This will close any currently open connections. The close may not complete until after this
   * method has returned.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @param completionHandler the handler
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

    /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    close(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Like {@link io.vertx.rxjava.core.net.NetServer#close} but supplying a handler that will be notified when close is complete.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * The actual port the server is listening on. This is useful if you bound the server specifying 0 as port number
   * signifying an ephemeral port
   * @return the actual port the server is listening on.
   */
  public int actualPort() { 
    int ret = delegate.actualPort();
    return ret;
  }

  public static NetServer newInstance(io.vertx.core.net.NetServer arg) {
    return arg != null ? new NetServer(arg) : null;
  }

}
