/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.net;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a socket-like interface to a TCP connection on either the
 * client or the server side.
 * <p>
 * Instances of this class are created on the client side by an {@link io.vertx.rxjava.core.net.NetClient}
 * when a connection to a server is made, or on the server side by a {@link io.vertx.rxjava.core.net.NetServer}
 * when a server accepts a connection.
 * <p>
 * It implements both  and  so it can be used with
 * {@link io.vertx.rxjava.core.streams.Pump} to pump data with flow control.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetSocket original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.net.NetSocket.class)
public class NetSocket implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer>, io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetSocket that = (NetSocket) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<NetSocket> __TYPE_ARG = new TypeArg<>(    obj -> new NetSocket((io.vertx.core.net.NetSocket) obj),
    NetSocket::getDelegate
  );

  private final io.vertx.core.net.NetSocket delegate;
  
  public NetSocket(io.vertx.core.net.NetSocket delegate) {
    this.delegate = delegate;
  }

  public NetSocket(Object delegate) {
    this.delegate = (io.vertx.core.net.NetSocket)delegate;
  }

  public io.vertx.core.net.NetSocket getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.buffer.Buffer> observable;

  public synchronized Observable<io.vertx.rxjava.core.buffer.Buffer> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.buffer.Buffer, io.vertx.rxjava.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> subscriber;

  public synchronized WriteStreamSubscriber<io.vertx.rxjava.core.buffer.Buffer> toSubscriber() {
    if (subscriber == null) {
      Function<io.vertx.rxjava.core.buffer.Buffer, io.vertx.core.buffer.Buffer> conv = io.vertx.rxjava.core.buffer.Buffer::getDelegate;
      subscriber = RxHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  private static final TypeArg<io.vertx.rxjava.core.buffer.Buffer> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.buffer.Buffer>(o1 -> io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#end} but writes some data to the stream before ending.
   * @param data the data to write
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.end(data.getDelegate());
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @param handler 
   */
  public void end(io.vertx.rxjava.core.buffer.Buffer data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(data.getDelegate(), handler);
  }

    /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   * @deprecated use {@link #rxEnd} instead
   */
  @Deprecated()
  public Observable<Void> endObservable(io.vertx.rxjava.core.buffer.Buffer data) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    end(data, handler.toHandler());
    return handler;
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * @param data 
   * @return 
   */
  public Single<Void> rxEnd(io.vertx.rxjava.core.buffer.Buffer data) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(data, fut);
    }));
  }

  /**
   * This will return <code>true</code> if there are more bytes in the write queue than the value set using {@link io.vertx.rxjava.core.net.NetSocket#setWriteQueueMaxSize}
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.buffer.Buffer> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   * @deprecated use {@link #rxPipeTo} instead
   */
  @Deprecated()
  public Observable<Void> pipeToObservable(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pipeTo(dst, handler.toHandler());
    return handler;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.buffer.Buffer> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  public io.vertx.rxjava.core.net.NetSocket exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket handler(Handler<io.vertx.rxjava.core.buffer.Buffer> handler) { 
    delegate.handler(new Handler<io.vertx.core.buffer.Buffer>() {
      public void handle(io.vertx.core.buffer.Buffer event) {
        handler.handle(io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)event));
      }
    });
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  /**
   * 
   * <p>
   * This handler might be called after the close handler when the socket is paused and there are still
   * buffers to deliver.
   * @param endHandler 
   * @return 
   */
  public io.vertx.rxjava.core.net.NetSocket endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket write(io.vertx.rxjava.core.buffer.Buffer data) { 
    delegate.write(data.getDelegate());
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  public io.vertx.rxjava.core.net.NetSocket drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  /**
   * When a <code>NetSocket</code> is created it automatically registers an event handler with the event bus, the ID of that
   * handler is given by <code>writeHandlerID</code>.
   * <p>
   * Given this ID, a different event loop can send a buffer to that event handler using the event bus and
   * that buffer will be received by this instance in its own event loop and written to the underlying connection. This
   * allows you to write data to other connections which are owned by different event loops.
   * @return the write handler ID
   */
  public String writeHandlerID() { 
    String ret = delegate.writeHandlerID();
    return ret;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.net.NetSocket write(String str, Handler<AsyncResult<Void>> handler) { 
    delegate.write(str, handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @return 
   * @deprecated use {@link #rxWrite} instead
   */
  @Deprecated()
  public Observable<Void> writeObservable(String str) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    write(str, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @return 
   */
  public Single<Void> rxWrite(String str) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(str, fut);
    }));
  }

  /**
   * Write a {@link java.lang.String} to the connection, encoded in UTF-8.
   * @param str the string to write
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket write(String str) { 
    delegate.write(str);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param enc 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.net.NetSocket write(String str, String enc, Handler<AsyncResult<Void>> handler) { 
    delegate.write(str, enc, handler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param enc 
   * @return 
   * @deprecated use {@link #rxWrite} instead
   */
  @Deprecated()
  public Observable<Void> writeObservable(String str, String enc) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    write(str, enc, handler.toHandler());
    return handler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#write} but with an <code>handler</code> called when the operation completes
   * @param str 
   * @param enc 
   * @return 
   */
  public Single<Void> rxWrite(String str, String enc) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(str, enc, fut);
    }));
  }

  /**
   * Write a {@link java.lang.String} to the connection, encoded using the encoding <code>enc</code>.
   * @param str the string to write
   * @param enc the encoding to use
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket write(String str, String enc) { 
    delegate.write(str, enc);
    return this;
  }

  /**
   * Like  but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * @param message 
   * @param handler 
   * @return 
   */
  public io.vertx.rxjava.core.net.NetSocket write(io.vertx.rxjava.core.buffer.Buffer message, Handler<AsyncResult<Void>> handler) { 
    delegate.write(message.getDelegate(), handler);
    return this;
  }

    /**
   * Like  but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * @param message 
   * @return 
   * @deprecated use {@link #rxWrite} instead
   */
  @Deprecated()
  public Observable<Void> writeObservable(io.vertx.rxjava.core.buffer.Buffer message) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    write(message, handler.toHandler());
    return handler;
  }

  /**
   * Like  but with an <code>handler</code> called when the message has been written
   * or failed to be written.
   * @param message 
   * @return 
   */
  public Single<Void> rxWrite(io.vertx.rxjava.core.buffer.Buffer message) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      write(message, fut);
    }));
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket sendFile(String filename) { 
    delegate.sendFile(filename);
    return this;
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket sendFile(String filename, long offset) { 
    delegate.sendFile(filename, offset);
    return this;
  }

  /**
   * Tell the operating system to stream a file as specified by <code>filename</code> directly from disk to the outgoing connection,
   * bypassing userspace altogether (where supported by the underlying operating system. This is a very efficient way to stream files.
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket sendFile(String filename, long offset, long length) { 
    delegate.sendFile(filename, offset, length);
    return this;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, resultHandler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxSendFile} instead
   */
  @Deprecated()
  public Observable<Void> sendFileObservable(String filename) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    sendFile(filename, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxSendFile(String filename) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sendFile(filename, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket sendFile(String filename, long offset, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, resultHandler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxSendFile} instead
   */
  @Deprecated()
  public Observable<Void> sendFileObservable(String filename, long offset) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    sendFile(filename, offset, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxSendFile(String filename, long offset) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sendFile(filename, offset, fut);
    }));
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @param resultHandler handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.sendFile(filename, offset, length, resultHandler);
    return this;
  }

    /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   * @deprecated use {@link #rxSendFile} instead
   */
  @Deprecated()
  public Observable<Void> sendFileObservable(String filename, long offset, long length) { 
    io.vertx.rx.java.ObservableFuture<Void> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    sendFile(filename, offset, length, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Same as {@link io.vertx.rxjava.core.net.NetSocket#sendFile} but also takes a handler that will be called when the send has completed or
   * a failure has occurred
   * @param filename file name of the file to send
   * @param offset offset
   * @param length length
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxSendFile(String filename, long offset, long length) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sendFile(filename, offset, length, fut);
    }));
  }

  /**
   * @return the remote address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.rxjava.core.net.SocketAddress remoteAddress() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.remoteAddress());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the local address for this connection, possibly <code>null</code> (e.g a server bound on a domain socket)
   */
  public io.vertx.rxjava.core.net.SocketAddress localAddress() { 
    if (cached_1 != null) {
      return cached_1;
    }
    io.vertx.rxjava.core.net.SocketAddress ret = io.vertx.rxjava.core.net.SocketAddress.newInstance((io.vertx.core.net.SocketAddress)delegate.localAddress());
    cached_1 = ret;
    return ret;
  }

  /**
   * Calls {@link io.vertx.rxjava.core.net.NetSocket#close}
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Calls {@link io.vertx.rxjava.core.net.NetSocket#end}
   * @param handler 
   */
  public void end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

    /**
   * Calls {@link io.vertx.rxjava.core.net.NetSocket#end}
   * @return 
   * @deprecated use {@link #rxEnd} instead
   */
  @Deprecated()
  public Observable<Void> endObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    end(handler.toHandler());
    return handler;
  }

  /**
   * Calls {@link io.vertx.rxjava.core.net.NetSocket#end}
   * @return 
   */
  public Single<Void> rxEnd() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      end(fut);
    }));
  }

  /**
   * Close the NetSocket
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(handler.toHandler());
    return handler;
  }

  /**
   * Close the NetSocket and notify the <code>handler</code> when the operation completes.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Set a handler that will be called when the NetSocket is closed
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket upgradeToSsl(Handler<Void> handler) { 
    delegate.upgradeToSsl(handler);
    return this;
  }

  /**
   * Upgrade channel to use SSL/TLS. Be aware that for this to work SSL must be configured.
   * @param serverName the server name
   * @param handler the handler will be notified when it's upgraded
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.net.NetSocket upgradeToSsl(String serverName, Handler<Void> handler) { 
    delegate.upgradeToSsl(serverName, handler);
    return this;
  }

  /**
   * @return true if this {@link io.vertx.rxjava.core.net.NetSocket} is encrypted via SSL/TLS.
   */
  public boolean isSsl() { 
    boolean ret = delegate.isSsl();
    return ret;
  }

  /**
   * Returns the SNI server name presented during the SSL handshake by the client.
   * @return the indicated server name
   */
  public String indicatedServerName() { 
    String ret = delegate.indicatedServerName();
    return ret;
  }

  /**
   * @return SSLSession associated with the underlying socket. Returns null if connection is not SSL.
   */
  public javax.net.ssl.SSLSession sslSession() { 
    javax.net.ssl.SSLSession ret = delegate.sslSession();
    return ret;
  }

  private io.vertx.rxjava.core.net.SocketAddress cached_0;
  private io.vertx.rxjava.core.net.SocketAddress cached_1;
  public static NetSocket newInstance(io.vertx.core.net.NetSocket arg) {
    return arg != null ? new NetSocket(arg) : null;
  }

}
