/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.core.parsetools;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A parser class which allows to incrementally parse json elements and emit json parse events instead of parsing a json
 * element fully. This parser is convenient for parsing large json structures.
 * <p/>
 * The parser also parses concatenated json streams or line delimited json streams.
 * <p/>
 * The parser can also parse entire object or array when it is convenient, for instance a very large array
 * of small objects can be parsed efficiently by handling array <i>start</i>/<i>end</i> and <i>object</i>
 * events.
 * <p/>
 * Whenever the parser fails to parse or process the stream, the {@link io.vertx.rxjava.core.parsetools.JsonParser#exceptionHandler} is called with
 * the cause of the failure and the current handling stops. After such event, the parser should not handle data
 * anymore.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.parsetools.JsonParser original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.core.parsetools.JsonParser.class)
public class JsonParser implements io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.parsetools.JsonEvent>, Handler<io.vertx.rxjava.core.buffer.Buffer> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JsonParser that = (JsonParser) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JsonParser> __TYPE_ARG = new TypeArg<>(    obj -> new JsonParser((io.vertx.core.parsetools.JsonParser) obj),
    JsonParser::getDelegate
  );

  private final io.vertx.core.parsetools.JsonParser delegate;
  
  public JsonParser(io.vertx.core.parsetools.JsonParser delegate) {
    this.delegate = delegate;
  }

  public JsonParser(Object delegate) {
    this.delegate = (io.vertx.core.parsetools.JsonParser)delegate;
  }

  public io.vertx.core.parsetools.JsonParser getDelegate() {
    return delegate;
  }

  private Observable<io.vertx.rxjava.core.parsetools.JsonEvent> observable;

  public synchronized Observable<io.vertx.rxjava.core.parsetools.JsonEvent> toObservable() {
    if (observable == null) {
      Function<io.vertx.core.parsetools.JsonEvent, io.vertx.rxjava.core.parsetools.JsonEvent> conv = io.vertx.rxjava.core.parsetools.JsonEvent::newInstance;
      observable = RxHelper.toObservable(delegate, conv);
    }
    return observable;
  }

  private static final TypeArg<io.vertx.rxjava.core.parsetools.JsonEvent> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.core.parsetools.JsonEvent>(o1 -> io.vertx.rxjava.core.parsetools.JsonEvent.newInstance((io.vertx.core.parsetools.JsonEvent)o1), o1 -> o1.getDelegate());

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.core.buffer.Buffer event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Pause this stream and return a  to transfer the elements of this stream to a destination .
   * <p/>
   * The stream will be resumed when the pipe will be wired to a <code>WriteStream</code>.
   * @return a pipe
   */
  public io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.parsetools.JsonEvent> pipe() { 
    io.vertx.rxjava.core.streams.Pipe<io.vertx.rxjava.core.parsetools.JsonEvent> ret = io.vertx.rxjava.core.streams.Pipe.newInstance((io.vertx.core.streams.Pipe)delegate.pipe(), TYPE_ARG_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.core.streams.ReadStream#pipeTo} but with no completion handler.
   * @param dst 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.parsetools.JsonEvent> dst) { 
    delegate.pipeTo(dst.getDelegate());
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @param handler 
   */
  public void pipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.parsetools.JsonEvent> dst, Handler<AsyncResult<Void>> handler) { 
    delegate.pipeTo(dst.getDelegate(), handler);
  }

    /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   * @deprecated use {@link #rxPipeTo} instead
   */
  @Deprecated()
  public Observable<Void> pipeToObservable(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.parsetools.JsonEvent> dst) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    pipeTo(dst, handler.toHandler());
    return handler;
  }

  /**
   * Pipe this <code>ReadStream</code> to the <code>WriteStream</code>.
   * <p>
   * Elements emitted by this stream will be written to the write stream until this stream ends or fails.
   * <p>
   * Once this stream has ended or failed, the write stream will be ended and the <code>handler</code> will be
   * called with the result.
   * @param dst the destination write stream
   * @return 
   */
  public Single<Void> rxPipeTo(io.vertx.rxjava.core.streams.WriteStream<io.vertx.rxjava.core.parsetools.JsonEvent> dst) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      pipeTo(dst, fut);
    }));
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.JsonParser newParser() { 
    io.vertx.rxjava.core.parsetools.JsonParser ret = io.vertx.rxjava.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser());
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.JsonParser newParser(io.vertx.rxjava.core.streams.ReadStream<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.JsonParser ret = io.vertx.rxjava.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser(stream.getDelegate()));
    return ret;
  }

  /**
   * Create a new <code>JsonParser</code> instance.
   * @param stream 
   * @return 
   */
  public static io.vertx.rxjava.core.parsetools.JsonParser newParser(Observable<io.vertx.rxjava.core.buffer.Buffer> stream) { 
    io.vertx.rxjava.core.parsetools.JsonParser ret = io.vertx.rxjava.core.parsetools.JsonParser.newInstance((io.vertx.core.parsetools.JsonParser)io.vertx.core.parsetools.JsonParser.newParser(io.vertx.rx.java.ReadStreamSubscriber.asReadStream(stream,obj -> (io.vertx.core.buffer.Buffer)obj.getDelegate()).resume()));
    return ret;
  }

  /**
   * Handle a <code>Buffer</code>, pretty much like calling {@link io.vertx.core.Handler}.
   * @param buffer 
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.parsetools.JsonParser write(io.vertx.rxjava.core.buffer.Buffer buffer) { 
    delegate.write(buffer.getDelegate());
    return this;
  }

  /**
   * End the stream, this must be called after all the json stream has been processed.
   */
  public void end() { 
    delegate.end();
  }

  /**
   * Flip the parser to emit a stream of events for each new json object.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.parsetools.JsonParser objectEventMode() { 
    delegate.objectEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json object.
   * </p>
   * Json object currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.parsetools.JsonParser objectValueMode() { 
    delegate.objectValueMode();
    return this;
  }

  /**
   * Flip the parser to emit a stream of events for each new json array.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.parsetools.JsonParser arrayEventMode() { 
    delegate.arrayEventMode();
    return this;
  }

  /**
   * Flip the parser to emit a single value event for each new json array.
   * </p>
   * Json array currently streamed won't be affected.
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.core.parsetools.JsonParser arrayValueMode() { 
    delegate.arrayValueMode();
    return this;
  }

  public io.vertx.rxjava.core.parsetools.JsonParser pause() { 
    delegate.pause();
    return this;
  }

  public io.vertx.rxjava.core.parsetools.JsonParser resume() { 
    delegate.resume();
    return this;
  }

  public io.vertx.rxjava.core.parsetools.JsonParser fetch(long amount) { 
    delegate.fetch(amount);
    return this;
  }

  public io.vertx.rxjava.core.parsetools.JsonParser endHandler(Handler<Void> endHandler) { 
    delegate.endHandler(endHandler);
    return this;
  }

  public io.vertx.rxjava.core.parsetools.JsonParser handler(Handler<io.vertx.rxjava.core.parsetools.JsonEvent> handler) { 
    delegate.handler(new Handler<io.vertx.core.parsetools.JsonEvent>() {
      public void handle(io.vertx.core.parsetools.JsonEvent event) {
        handler.handle(io.vertx.rxjava.core.parsetools.JsonEvent.newInstance((io.vertx.core.parsetools.JsonEvent)event));
      }
    });
    return this;
  }

  public io.vertx.rxjava.core.parsetools.JsonParser exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public static JsonParser newInstance(io.vertx.core.parsetools.JsonParser arg) {
    return arg != null ? new JsonParser(arg) : null;
  }

}
