/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.db2client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to DB2 server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.db2client.DB2Connection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.db2client.DB2Connection.class)
public class DB2Connection extends io.vertx.rxjava.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DB2Connection that = (DB2Connection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DB2Connection> __TYPE_ARG = new TypeArg<>(    obj -> new DB2Connection((io.vertx.db2client.DB2Connection) obj),
    DB2Connection::getDelegate
  );

  private final io.vertx.db2client.DB2Connection delegate;
  
  public DB2Connection(io.vertx.db2client.DB2Connection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public DB2Connection(Object delegate) {
    super((io.vertx.db2client.DB2Connection)delegate);
    this.delegate = (io.vertx.db2client.DB2Connection)delegate;
  }

  public io.vertx.db2client.DB2Connection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to DB2 server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions, Handler<AsyncResult<io.vertx.rxjava.db2client.DB2Connection>> handler) { 
    io.vertx.db2client.DB2Connection.connect(vertx.getDelegate(), connectOptions, new Handler<AsyncResult<io.vertx.db2client.DB2Connection>>() {
      public void handle(AsyncResult<io.vertx.db2client.DB2Connection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Create a connection to DB2 server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static Single<io.vertx.rxjava.db2client.DB2Connection> rxConnect(io.vertx.rxjava.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectOptions, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.db2client.DB2Connection#connect} with options build
   * from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, String connectionUri, Handler<AsyncResult<io.vertx.rxjava.db2client.DB2Connection>> handler) { 
    io.vertx.db2client.DB2Connection.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.vertx.db2client.DB2Connection>>() {
      public void handle(AsyncResult<io.vertx.db2client.DB2Connection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.db2client.DB2Connection.newInstance((io.vertx.db2client.DB2Connection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Like {@link io.vertx.rxjava.db2client.DB2Connection#connect} with options build
   * from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static Single<io.vertx.rxjava.db2client.DB2Connection> rxConnect(io.vertx.rxjava.core.Vertx vertx, String connectionUri) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectionUri, fut);
    }));
  }

  public io.vertx.rxjava.db2client.DB2Connection prepare(String sql, Handler<AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    public Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      prepare(sql, fut);
    }));
  }

  public io.vertx.rxjava.db2client.DB2Connection exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.db2client.DB2Connection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @param handler the handler notified when the server responses to client
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.db2client.DB2Connection ping(Handler<AsyncResult<Void>> handler) { 
    delegate.ping(handler);
    return this;
  }

    /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxPing() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      ping(fut);
    }));
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.db2client.DB2Connection debug(Handler<AsyncResult<Void>> handler) { 
    delegate.debug(handler);
    return this;
  }

    /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxDebug() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      debug(fut);
    }));
  }

  public static DB2Connection newInstance(io.vertx.db2client.DB2Connection arg) {
    return arg != null ? new DB2Connection(arg) : null;
  }

}
