/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.db2client;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A pool of DB2 connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.db2client.DB2Pool original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.db2client.DB2Pool.class)
public class DB2Pool extends io.vertx.rxjava.sqlclient.Pool {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DB2Pool that = (DB2Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<DB2Pool> __TYPE_ARG = new TypeArg<>(    obj -> new DB2Pool((io.vertx.db2client.DB2Pool) obj),
    DB2Pool::getDelegate
  );

  private final io.vertx.db2client.DB2Pool delegate;
  
  public DB2Pool(io.vertx.db2client.DB2Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public DB2Pool(Object delegate) {
    super((io.vertx.db2client.DB2Pool)delegate);
    this.delegate = (io.vertx.db2client.DB2Pool)delegate;
  }

  public io.vertx.db2client.DB2Pool getDelegate() {
    return delegate;
  }

  /**
   * Like {@link io.vertx.rxjava.db2client.DB2Pool#pool} with a default <code>poolOptions</code>.
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.rxjava.db2client.DB2Pool pool(String connectionUri) { 
    io.vertx.rxjava.db2client.DB2Pool ret = io.vertx.rxjava.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.db2client.DB2Pool#pool} with
   * <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava.db2client.DB2Pool pool(String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava.db2client.DB2Pool ret = io.vertx.rxjava.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(connectionUri, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.db2client.DB2Pool#pool} with a default
   * <code>poolOptions</code>..
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static io.vertx.rxjava.db2client.DB2Pool pool(io.vertx.rxjava.core.Vertx vertx, String connectionUri) { 
    io.vertx.rxjava.db2client.DB2Pool ret = io.vertx.rxjava.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), connectionUri));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.db2client.DB2Pool#pool} with
   * <code>connectOptions</code> build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava.db2client.DB2Pool pool(io.vertx.rxjava.core.Vertx vertx, String connectionUri, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava.db2client.DB2Pool ret = io.vertx.rxjava.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), connectionUri, poolOptions));
    return ret;
  }

  /**
   * Create a connection pool to the DB2 server configured with the given
   * <code>connectOptions</code> and <code>poolOptions</code>.
   * @param connectOptions the options for the connection
   * @param poolOptions the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.rxjava.db2client.DB2Pool pool(io.vertx.db2client.DB2ConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava.db2client.DB2Pool ret = io.vertx.rxjava.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(connectOptions, poolOptions));
    return ret;
  }

  /**
   * Like {@link io.vertx.rxjava.db2client.DB2Pool#pool} with a specific
   *  instance.
   * @param vertx 
   * @param connectOptions 
   * @param poolOptions 
   * @return 
   */
  public static io.vertx.rxjava.db2client.DB2Pool pool(io.vertx.rxjava.core.Vertx vertx, io.vertx.db2client.DB2ConnectOptions connectOptions, io.vertx.sqlclient.PoolOptions poolOptions) { 
    io.vertx.rxjava.db2client.DB2Pool ret = io.vertx.rxjava.db2client.DB2Pool.newInstance((io.vertx.db2client.DB2Pool)io.vertx.db2client.DB2Pool.pool(vertx.getDelegate(), connectOptions, poolOptions));
    return ret;
  }

  public static DB2Pool newInstance(io.vertx.db2client.DB2Pool arg) {
    return arg != null ? new DB2Pool(arg) : null;
  }

}
