/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * AccessToken extension to the User interface
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.AccessToken original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.AccessToken.class)
public class AccessToken extends io.vertx.rxjava.ext.auth.User {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AccessToken that = (AccessToken) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<AccessToken> __TYPE_ARG = new TypeArg<>(    obj -> new AccessToken((io.vertx.ext.auth.oauth2.AccessToken) obj),
    AccessToken::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.AccessToken delegate;
  
  public AccessToken(io.vertx.ext.auth.oauth2.AccessToken delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public AccessToken(Object delegate) {
    super((io.vertx.ext.auth.oauth2.AccessToken)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.AccessToken)delegate;
  }

  public io.vertx.ext.auth.oauth2.AccessToken getDelegate() {
    return delegate;
  }

  /**
   * Check if the access token is expired or not.
   * @return 
   */
  public boolean expired() { 
    boolean ret = delegate.expired();
    return ret;
  }

  /**
   * The Access Token if present parsed as a JsonObject
   * @return JSON
   */
  public JsonObject accessToken() { 
    if (cached_0 != null) {
      return cached_0;
    }
    JsonObject ret = delegate.accessToken();
    cached_0 = ret;
    return ret;
  }

  /**
   * The Refresh Token if present parsed as a JsonObject
   * @return JSON
   */
  @Deprecated()
  public JsonObject refreshToken() { 
    if (cached_1 != null) {
      return cached_1;
    }
    JsonObject ret = delegate.refreshToken();
    cached_1 = ret;
    return ret;
  }

  /**
   * The Id Token if present parsed as a JsonObject
   * @return JSON
   */
  public JsonObject idToken() { 
    if (cached_2 != null) {
      return cached_2;
    }
    JsonObject ret = delegate.idToken();
    cached_2 = ret;
    return ret;
  }

  /**
   * The RAW String if available for the Access Token
   * @return String
   */
  public String opaqueAccessToken() { 
    String ret = delegate.opaqueAccessToken();
    return ret;
  }

  /**
   * The RAW String if available for the Refresh Token
   * @return String
   */
  public String opaqueRefreshToken() { 
    String ret = delegate.opaqueRefreshToken();
    return ret;
  }

  /**
   * The RAW String if available for the Id Token
   * @return String
   */
  public String opaqueIdToken() { 
    String ret = delegate.opaqueIdToken();
    return ret;
  }

  public String tokenType() { 
    String ret = delegate.tokenType();
    return ret;
  }

  public io.vertx.rxjava.ext.auth.oauth2.AccessToken setTrustJWT(boolean trust) { 
    delegate.setTrustJWT(trust);
    return this;
  }

  /**
   * Refresh the access token
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken refresh(Handler<AsyncResult<Void>> callback) { 
    delegate.refresh(callback);
    return this;
  }

    /**
   * Refresh the access token
   * @return 
   * @deprecated use {@link #rxRefresh} instead
   */
  @Deprecated()
  public Observable<Void> refreshObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    refresh(callback.toHandler());
    return callback;
  }

  /**
   * Refresh the access token
   * @return 
   */
  public Single<Void> rxRefresh() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      refresh(fut);
    }));
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken revoke(String token_type, Handler<AsyncResult<Void>> callback) { 
    delegate.revoke(token_type, callback);
    return this;
  }

    /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   * @deprecated use {@link #rxRevoke} instead
   */
  @Deprecated()
  public Observable<Void> revokeObservable(String token_type) { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    revoke(token_type, callback.toHandler());
    return callback;
  }

  /**
   * Revoke access or refresh token
   * @param token_type - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Single<Void> rxRevoke(String token_type) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      revoke(token_type, fut);
    }));
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken logout(Handler<AsyncResult<Void>> callback) { 
    delegate.logout(callback);
    return this;
  }

    /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   * @deprecated use {@link #rxLogout} instead
   */
  @Deprecated()
  public Observable<Void> logoutObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    logout(callback.toHandler());
    return callback;
  }

  /**
   * Revoke refresh token and calls the logout endpoint. This is a openid-connect extension and might not be
   * available on all providers.
   * @return 
   */
  public Single<Void> rxLogout() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      logout(fut);
    }));
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken introspect(Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(callback);
    return this;
  }

    /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   * @deprecated use {@link #rxIntrospect} instead
   */
  @Deprecated()
  public Observable<Void> introspectObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    introspect(callback.toHandler());
    return callback;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @return 
   */
  public Single<Void> rxIntrospect() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      introspect(fut);
    }));
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken introspect(String tokenType, Handler<AsyncResult<Void>> callback) { 
    delegate.introspect(tokenType, callback);
    return this;
  }

    /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   * @deprecated use {@link #rxIntrospect} instead
   */
  @Deprecated()
  public Observable<Void> introspectObservable(String tokenType) { 
    io.vertx.rx.java.ObservableFuture<Void> callback = io.vertx.rx.java.RxHelper.observableFuture();
    introspect(tokenType, callback.toHandler());
    return callback;
  }

  /**
   * Introspect access token. This is an OAuth2 extension that allow to verify if an access token is still valid.
   * @param tokenType - A String containing the type of token to revoke. Should be either "access_token" or "refresh_token".
   * @return 
   */
  public Single<Void> rxIntrospect(String tokenType) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      introspect(tokenType, fut);
    }));
  }

  /**
   * Load the user info as per OIDC spec.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken userInfo(Handler<AsyncResult<JsonObject>> callback) { 
    delegate.userInfo(callback);
    return this;
  }

    /**
   * Load the user info as per OIDC spec.
   * @return 
   * @deprecated use {@link #rxUserInfo} instead
   */
  @Deprecated()
  public Observable<JsonObject> userInfoObservable() { 
    io.vertx.rx.java.ObservableFuture<JsonObject> callback = io.vertx.rx.java.RxHelper.observableFuture();
    userInfo(callback.toHandler());
    return callback;
  }

  /**
   * Load the user info as per OIDC spec.
   * @return 
   */
  public Single<JsonObject> rxUserInfo() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      userInfo(fut);
    }));
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken fetch(String resource, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response>> callback) { 
    delegate.fetch(resource, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   * @deprecated use {@link #rxFetch} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response> fetchObservable(String resource) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response> callback = io.vertx.rx.java.RxHelper.observableFuture();
    fetch(resource, callback.toHandler());
    return callback;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param resource - the resource to fetch.
   * @return 
   */
  public Single<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response> rxFetch(String resource) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      fetch(resource, fut);
    }));
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @param callback - The callback function returning the results.
   * @return 
   */
  public io.vertx.rxjava.ext.auth.oauth2.AccessToken fetch(io.vertx.core.http.HttpMethod method, String resource, JsonObject headers, io.vertx.rxjava.core.buffer.Buffer payload, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response>> callback) { 
    delegate.fetch(method, resource, headers, payload.getDelegate(), new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Response> ar) {
        if (ar.succeeded()) {
          callback.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.OAuth2Response.newInstance((io.vertx.ext.auth.oauth2.OAuth2Response)ar.result())));
        } else {
          callback.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   * @deprecated use {@link #rxFetch} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response> fetchObservable(io.vertx.core.http.HttpMethod method, String resource, JsonObject headers, io.vertx.rxjava.core.buffer.Buffer payload) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response> callback = io.vertx.rx.java.RxHelper.observableFuture();
    fetch(method, resource, headers, payload, callback.toHandler());
    return callback;
  }

  /**
   * Fetches a JSON resource using this Access Token.
   * @param method - the HTTP method to user.
   * @param resource - the resource to fetch.
   * @param headers - extra headers to pass to the request.
   * @param payload - payload to send to the server.
   * @return 
   */
  public Single<io.vertx.rxjava.ext.auth.oauth2.OAuth2Response> rxFetch(io.vertx.core.http.HttpMethod method, String resource, JsonObject headers, io.vertx.rxjava.core.buffer.Buffer payload) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      fetch(method, resource, headers, payload, fut);
    }));
  }

  private JsonObject cached_0;
  private JsonObject cached_1;
  private JsonObject cached_2;
  public static AccessToken newInstance(io.vertx.ext.auth.oauth2.AccessToken arg) {
    return arg != null ? new AccessToken(arg) : null;
  }

}
