/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Factory interface for creating OAuth2 based {@link io.vertx.rxjava.ext.auth.AuthProvider} instances.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.OAuth2Auth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.OAuth2Auth.class)
public class OAuth2Auth extends io.vertx.rxjava.ext.auth.AuthProvider {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2Auth that = (OAuth2Auth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OAuth2Auth> __TYPE_ARG = new TypeArg<>(    obj -> new OAuth2Auth((io.vertx.ext.auth.oauth2.OAuth2Auth) obj),
    OAuth2Auth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.OAuth2Auth delegate;
  
  public OAuth2Auth(io.vertx.ext.auth.oauth2.OAuth2Auth delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public OAuth2Auth(Object delegate) {
    super((io.vertx.ext.auth.oauth2.OAuth2Auth)delegate);
    this.delegate = (io.vertx.ext.auth.oauth2.OAuth2Auth)delegate;
  }

  public io.vertx.ext.auth.oauth2.OAuth2Auth getDelegate() {
    return delegate;
  }

  /**
   * @param vertx the Vertx instance
   * @param flow 
   * @param config the config as exported from the admin console
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth createKeycloak(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow, JsonObject config) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.createKeycloak(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @param flow 
   * @param config the config
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow, io.vertx.ext.auth.oauth2.OAuth2ClientOptions config) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow, config));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @param flow 
   * @return the auth provider
   */
  @Deprecated()
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2FlowType flow) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), flow));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @return the auth provider
   */
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Create a OAuth2 auth provider
   * @param vertx the Vertx instance
   * @param config the config
   * @return the auth provider
   */
  public static io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2ClientOptions config) { 
    io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth ret = io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)io.vertx.ext.auth.oauth2.OAuth2Auth.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Generate a redirect URL to the authN/Z backend. It only applies to auth_code flow.
   * @param params 
   * @return 
   */
  public String authorizeURL(JsonObject params) { 
    String ret = delegate.authorizeURL(params);
    return ret;
  }

  /**
   * Returns the Access Token object.
   * @param params - JSON with the options, each flow requires different options.
   * @param handler - The handler returning the results.
   */
  @Deprecated()
  public void getToken(JsonObject params, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.AccessToken>> handler) { 
    delegate.getToken(params, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Returns the Access Token object.
   * @param params - JSON with the options, each flow requires different options.
   * @return 
   * @deprecated use {@link #rxGetToken} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.oauth2.AccessToken> getTokenObservable(JsonObject params) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.AccessToken> handler = io.vertx.rx.java.RxHelper.observableFuture();
    getToken(params, handler.toHandler());
    return handler;
  }

  /**
   * Returns the Access Token object.
   * @param params - JSON with the options, each flow requires different options.
   * @return 
   */
  @Deprecated()
  public Single<io.vertx.rxjava.ext.auth.oauth2.AccessToken> rxGetToken(JsonObject params) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getToken(params, fut);
    }));
  }

  /**
   * Decode a token to a {@link io.vertx.rxjava.ext.auth.oauth2.AccessToken} object. This is useful to handle bearer JWT tokens.
   * @param token the access token (base64 string)
   * @param handler A handler to receive the event
   * @return self
   */
  @Deprecated()
  public io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth decodeToken(String token, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.AccessToken>> handler) { 
    delegate.decodeToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Decode a token to a {@link io.vertx.rxjava.ext.auth.oauth2.AccessToken} object. This is useful to handle bearer JWT tokens.
   * @param token the access token (base64 string)
   * @return self
   * @deprecated use {@link #rxDecodeToken} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.oauth2.AccessToken> decodeTokenObservable(String token) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.AccessToken> handler = io.vertx.rx.java.RxHelper.observableFuture();
    decodeToken(token, handler.toHandler());
    return handler;
  }

  /**
   * Decode a token to a {@link io.vertx.rxjava.ext.auth.oauth2.AccessToken} object. This is useful to handle bearer JWT tokens.
   * @param token the access token (base64 string)
   * @return self
   */
  @Deprecated()
  public Single<io.vertx.rxjava.ext.auth.oauth2.AccessToken> rxDecodeToken(String token) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      decodeToken(token, fut);
    }));
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param handler A handler to receive the event
   * @return self
   */
  @Deprecated()
  public io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth introspectToken(String token, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.AccessToken>> handler) { 
    delegate.introspectToken(token, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @return self
   * @deprecated use {@link #rxIntrospectToken} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.oauth2.AccessToken> introspectTokenObservable(String token) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.AccessToken> handler = io.vertx.rx.java.RxHelper.observableFuture();
    introspectToken(token, handler.toHandler());
    return handler;
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @return self
   */
  @Deprecated()
  public Single<io.vertx.rxjava.ext.auth.oauth2.AccessToken> rxIntrospectToken(String token) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      introspectToken(token, fut);
    }));
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param tokenType hint to the token type e.g.: `access_token`
   * @param handler A handler to receive the event
   * @return self
   */
  @Deprecated()
  public io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth introspectToken(String token, String tokenType, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.AccessToken>> handler) { 
    delegate.introspectToken(token, tokenType, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.AccessToken>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.AccessToken> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.AccessToken.newInstance((io.vertx.ext.auth.oauth2.AccessToken)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param tokenType hint to the token type e.g.: `access_token`
   * @return self
   * @deprecated use {@link #rxIntrospectToken} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.auth.oauth2.AccessToken> introspectTokenObservable(String token, String tokenType) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.AccessToken> handler = io.vertx.rx.java.RxHelper.observableFuture();
    introspectToken(token, tokenType, handler.toHandler());
    return handler;
  }

  /**
   * Query an OAuth 2.0 authorization server to determine the active state of an OAuth 2.0 token and to determine
   * meta-information about this token.
   * @param token the access token (base64 string)
   * @param tokenType hint to the token type e.g.: `access_token`
   * @return self
   */
  @Deprecated()
  public Single<io.vertx.rxjava.ext.auth.oauth2.AccessToken> rxIntrospectToken(String token, String tokenType) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      introspectToken(token, tokenType, fut);
    }));
  }

  /**
   * Returns the scope separator.
   *
   * The RFC 6749 states that a scope is expressed as a set of case-sensitive and space-delimited strings, however
   * vendors tend not to agree on this and we see the following cases being used: space, plus sign, comma.
   * @return what value was used in the configuration of the object, falling back to the default value which is a space.
   */
  @Deprecated()
  public String getScopeSeparator() { 
    String ret = delegate.getScopeSeparator();
    return ret;
  }

  /**
   * Returns the configured flow type for the Oauth2 provider.
   * @return the flow type.
   */
  @Deprecated()
  public io.vertx.ext.auth.oauth2.OAuth2FlowType getFlowType() { 
    io.vertx.ext.auth.oauth2.OAuth2FlowType ret = delegate.getFlowType();
    return ret;
  }

  /**
   * Loads a JWK Set from the remote provider.
   *
   * When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
   * @param handler 
   * @return 
   */
  @Deprecated()
  public io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth loadJWK(Handler<AsyncResult<Void>> handler) { 
    delegate.loadJWK(handler);
    return this;
  }

    /**
   * Loads a JWK Set from the remote provider.
   *
   * When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
   * @return 
   * @deprecated use {@link #rxLoadJWK} instead
   */
  @Deprecated()
  public Observable<Void> loadJWKObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    loadJWK(handler.toHandler());
    return handler;
  }

  /**
   * Loads a JWK Set from the remote provider.
   *
   * When calling this method several times, the loaded JWKs are updated in the underlying JWT object.
   * @return 
   */
  @Deprecated()
  public Single<Void> rxLoadJWK() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      loadJWK(fut);
    }));
  }

  @Deprecated()
  public io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth rbacHandler(io.vertx.rxjava.ext.auth.oauth2.OAuth2RBAC rbac) { 
    delegate.rbacHandler(rbac.getDelegate());
    return this;
  }

  /**
   * Handled to be called when a key (mentioned on a JWT) is missing from the current config.
   * Users are advised to call {@link io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth#loadJWK} but being careful to implement
   * some rate limiting function.
   *
   * This method isn't generic for several reasons. The provider is not aware of the capabilities
   * of the backend IdP in terms of max allowed API calls. Some validation could be done at the
   * key id, which only the end user is aware of.
   * @param handler 
   * @return Future result.
   */
  public io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth missingKeyHandler(Handler<String> handler) { 
    delegate.missingKeyHandler(handler);
    return this;
  }

  public static OAuth2Auth newInstance(io.vertx.ext.auth.oauth2.OAuth2Auth arg) {
    return arg != null ? new OAuth2Auth(arg) : null;
  }

}
