/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.auth.oauth2.providers;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Simplified factory to create an {@link io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth} for OpenID Connect.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.class)
public class OpenIDConnectAuth {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OpenIDConnectAuth that = (OpenIDConnectAuth) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<OpenIDConnectAuth> __TYPE_ARG = new TypeArg<>(    obj -> new OpenIDConnectAuth((io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth) obj),
    OpenIDConnectAuth::getDelegate
  );

  private final io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate;
  
  public OpenIDConnectAuth(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth delegate) {
    this.delegate = delegate;
  }

  public OpenIDConnectAuth(Object delegate) {
    this.delegate = (io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth)delegate;
  }

  public io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth getDelegate() {
    return delegate;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
   * configuration options and attempt to load the well known descriptor.
   *
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @param handler the instantiated Oauth2 provider instance handler
   */
  public static void discover(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2ClientOptions config, Handler<AsyncResult<io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth>> handler) { 
    io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth.discover(vertx.getDelegate(), config, new Handler<AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth>>() {
      public void handle(AsyncResult<io.vertx.ext.auth.oauth2.OAuth2Auth> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth.newInstance((io.vertx.ext.auth.oauth2.OAuth2Auth)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
   * configuration options and attempt to load the well known descriptor.
   *
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @return 
   * @deprecated use {@link #rxDiscover} instead
   */
  @Deprecated()
  public static Observable<io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth> discoverObservable(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2ClientOptions config) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth> handler = io.vertx.rx.java.RxHelper.observableFuture();
    discover(vertx, config, handler.toHandler());
    return handler;
  }

  /**
   * Create a OAuth2Auth provider for OpenID Connect Discovery. The discovery will use the given site in the
   * configuration options and attempt to load the well known descriptor.
   *
   * If the discovered config includes a json web key url, it will be also fetched and the JWKs will be loaded
   * into the OAuth provider so tokens can be decoded.
   * @param vertx the vertx instance
   * @param config the initial config, it should contain a site url
   * @return 
   */
  public static Single<io.vertx.rxjava.ext.auth.oauth2.OAuth2Auth> rxDiscover(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.auth.oauth2.OAuth2ClientOptions config) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      discover(vertx, config, fut);
    }));
  }

  public static OpenIDConnectAuth newInstance(io.vertx.ext.auth.oauth2.providers.OpenIDConnectAuth arg) {
    return arg != null ? new OpenIDConnectAuth(arg) : null;
  }

}
