/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.shell;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * The shell server.<p/>
 *
 * A shell server is associated with a collection of : the {@link io.vertx.rxjava.ext.shell.ShellServer#registerTermServer}
 * method registers a term server. Term servers life cycle are managed by this server.<p/>
 *
 * When a  receives an incoming connection, a  instance is created and
 * associated with this connection.<p/>
 *
 * The {@link io.vertx.rxjava.ext.shell.ShellServer#createShell} method can be used to create  instance for testing purposes.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.shell.ShellServer original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.shell.ShellServer.class)
public class ShellServer {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ShellServer that = (ShellServer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<ShellServer> __TYPE_ARG = new TypeArg<>(    obj -> new ShellServer((io.vertx.ext.shell.ShellServer) obj),
    ShellServer::getDelegate
  );

  private final io.vertx.ext.shell.ShellServer delegate;
  
  public ShellServer(io.vertx.ext.shell.ShellServer delegate) {
    this.delegate = delegate;
  }

  public ShellServer(Object delegate) {
    this.delegate = (io.vertx.ext.shell.ShellServer)delegate;
  }

  public io.vertx.ext.shell.ShellServer getDelegate() {
    return delegate;
  }

  /**
   * Create a new shell server with default options.
   * @param vertx the vertx
   * @param options the options
   * @return the created shell server
   */
  public static io.vertx.rxjava.ext.shell.ShellServer create(io.vertx.rxjava.core.Vertx vertx, io.vertx.ext.shell.ShellServerOptions options) { 
    io.vertx.rxjava.ext.shell.ShellServer ret = io.vertx.rxjava.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)io.vertx.ext.shell.ShellServer.create(vertx.getDelegate(), options));
    return ret;
  }

  /**
   * Create a new shell server with specific options.
   * @param vertx the vertx
   * @return the created shell server
   */
  public static io.vertx.rxjava.ext.shell.ShellServer create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.shell.ShellServer ret = io.vertx.rxjava.ext.shell.ShellServer.newInstance((io.vertx.ext.shell.ShellServer)io.vertx.ext.shell.ShellServer.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Register a command resolver for this server.
   * @param resolver the resolver
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.ShellServer registerCommandResolver(io.vertx.rxjava.ext.shell.command.CommandResolver resolver) { 
    delegate.registerCommandResolver(resolver.getDelegate());
    return this;
  }

  /**
   * Register a term server to this shell server, the term server lifecycle methods are managed by this shell server.
   * @param termServer the term server to add
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.shell.ShellServer registerTermServer(io.vertx.rxjava.ext.shell.term.TermServer termServer) { 
    delegate.registerTermServer(termServer.getDelegate());
    return this;
  }

  /**
   * Create a new shell, the returned shell should be closed explicitely.
   * @param term the shell associated terminal
   * @return the created shell
   */
  public io.vertx.rxjava.ext.shell.Shell createShell(io.vertx.rxjava.ext.shell.term.Term term) { 
    io.vertx.rxjava.ext.shell.Shell ret = io.vertx.rxjava.ext.shell.Shell.newInstance((io.vertx.ext.shell.Shell)delegate.createShell(term.getDelegate()));
    return ret;
  }

  /**
   * Create a new shell, the returned shell should be closed explicitely.
   * @return the created shell
   */
  public io.vertx.rxjava.ext.shell.Shell createShell() { 
    io.vertx.rxjava.ext.shell.Shell ret = io.vertx.rxjava.ext.shell.Shell.newInstance((io.vertx.ext.shell.Shell)delegate.createShell());
    return ret;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * @return 
   */
  public io.vertx.rxjava.ext.shell.ShellServer listen() { 
    delegate.listen();
    return this;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * @param listenHandler handler for getting notified when service is started
   * @return 
   */
  public io.vertx.rxjava.ext.shell.ShellServer listen(Handler<AsyncResult<Void>> listenHandler) { 
    delegate.listen(listenHandler);
    return this;
  }

    /**
   * Start the shell service, this is an asynchronous start.
   * @return 
   * @deprecated use {@link #rxListen} instead
   */
  @Deprecated()
  public Observable<Void> listenObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> listenHandler = io.vertx.rx.java.RxHelper.observableFuture();
    listen(listenHandler.toHandler());
    return listenHandler;
  }

  /**
   * Start the shell service, this is an asynchronous start.
   * @return 
   */
  public Single<Void> rxListen() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      listen(fut);
    }));
  }

  /**
   * Close the shell server, this is an asynchronous close.
   */
  public void close() { 
    delegate.close();
  }

  /**
   * Close the shell server, this is an asynchronous close.
   * @param completionHandler handler for getting notified when service is stopped
   */
  public void close(Handler<AsyncResult<Void>> completionHandler) { 
    delegate.close(completionHandler);
  }

    /**
   * Close the shell server, this is an asynchronous close.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> completionHandler = io.vertx.rx.java.RxHelper.observableFuture();
    close(completionHandler.toHandler());
    return completionHandler;
  }

  /**
   * Close the shell server, this is an asynchronous close.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Called when a new shell is created. Can be used to prepopulate the shell session with objects
   * or set the prompt.
   * @param shellHandler handler for getting notified when the server creates a new shell.
   */
  public void shellHandler(Handler<io.vertx.rxjava.ext.shell.Shell> shellHandler) { 
    delegate.shellHandler(new Handler<io.vertx.ext.shell.Shell>() {
      public void handle(io.vertx.ext.shell.Shell event) {
        shellHandler.handle(io.vertx.rxjava.ext.shell.Shell.newInstance((io.vertx.ext.shell.Shell)event));
      }
    });
  }

  public static ShellServer newInstance(io.vertx.ext.shell.ShellServer arg) {
    return arg != null ? new ShellServer(arg) : null;
  }

}
