/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.sql;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represents a SQL query interface to a database
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.sql.SQLOperations original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.sql.SQLOperations.class)
public interface SQLOperations {

  io.vertx.ext.sql.SQLOperations getDelegate();

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations query(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations queryWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations queryStream(String sql, Handler<AsyncResult<io.vertx.rxjava.ext.sql.SQLRowStream>> handler);

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.rxjava.ext.sql.SQLRowStream>> handler);

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler);

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler);

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations update(String sql, Handler<AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler);

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations updateWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations call(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler);

  public static SQLOperations newInstance(io.vertx.ext.sql.SQLOperations arg) {
    return arg != null ? new SQLOperationsImpl(arg) : null;
  }

}

class SQLOperationsImpl implements SQLOperations {
  private final io.vertx.ext.sql.SQLOperations delegate;
  
  public SQLOperationsImpl(io.vertx.ext.sql.SQLOperations delegate) {
    this.delegate = delegate;
  }

  public SQLOperationsImpl(Object delegate) {
    this.delegate = (io.vertx.ext.sql.SQLOperations)delegate;
  }

  public io.vertx.ext.sql.SQLOperations getDelegate() {
    return delegate;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations query(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.query(sql, resultHandler);
    return this;
  }

    /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   * @deprecated use {@link #rxQuery} instead
   */
  @Deprecated()
  public Observable<io.vertx.ext.sql.ResultSet> queryObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.ext.sql.ResultSet> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    query(sql, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public Single<io.vertx.ext.sql.ResultSet> rxQuery(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      query(sql, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations queryWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.queryWithParams(sql, params, resultHandler);
    return this;
  }

    /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   * @deprecated use {@link #rxQueryWithParams} instead
   */
  @Deprecated()
  public Observable<io.vertx.ext.sql.ResultSet> queryWithParamsObservable(String sql, JsonArray params) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.ext.sql.ResultSet> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    queryWithParams(sql, params, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Executes the given SQL <code>SELECT</code> prepared statement which returns the results of the query.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<io.vertx.ext.sql.ResultSet> rxQueryWithParams(String sql, JsonArray params) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queryWithParams(sql, params, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations queryStream(String sql, Handler<AsyncResult<io.vertx.rxjava.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStream(sql, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   * @deprecated use {@link #rxQueryStream} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.sql.SQLRowStream> queryStreamObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.sql.SQLRowStream> handler = io.vertx.rx.java.RxHelper.observableFuture();
    queryStream(sql, handler.toHandler());
    return handler;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @return 
   */
  public Single<io.vertx.rxjava.ext.sql.SQLRowStream> rxQueryStream(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queryStream(sql, fut);
    }));
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @param handler the handler which is called once the operation completes. It will return a <code>SQLRowStream</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations queryStreamWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.rxjava.ext.sql.SQLRowStream>> handler) { 
    delegate.queryStreamWithParams(sql, params, new Handler<AsyncResult<io.vertx.ext.sql.SQLRowStream>>() {
      public void handle(AsyncResult<io.vertx.ext.sql.SQLRowStream> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.sql.SQLRowStream.newInstance((io.vertx.ext.sql.SQLRowStream)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   * @deprecated use {@link #rxQueryStreamWithParams} instead
   */
  @Deprecated()
  public Observable<io.vertx.rxjava.ext.sql.SQLRowStream> queryStreamWithParamsObservable(String sql, JsonArray params) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.rxjava.ext.sql.SQLRowStream> handler = io.vertx.rx.java.RxHelper.observableFuture();
    queryStreamWithParams(sql, params, handler.toHandler());
    return handler;
  }

  /**
   * Executes the given SQL <code>SELECT</code> statement which returns the results of the query as a read stream.
   * @param sql the SQL to execute. For example <code>SELECT * FROM table ...</code>.
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<io.vertx.rxjava.ext.sql.SQLRowStream> rxQueryStreamWithParams(String sql, JsonArray params) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      queryStreamWithParams(sql, params, fut);
    }));
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingle(String sql, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingle(sql, handler);
    return this;
  }

    /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   * @deprecated use {@link #rxQuerySingle} instead
   */
  @Deprecated()
  public Observable<JsonArray> querySingleObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    querySingle(sql, handler.toHandler());
    return handler;
  }

  /**
   * Execute a one shot SQL statement that returns a single SQL row. This method will reduce the boilerplate code by
   * getting a connection from the pool (this object) and return it back after the execution. Only the first result
   * from the result set is returned.
   * @param sql the statement to execute
   * @return self
   */
  public Single<JsonArray> rxQuerySingle(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      querySingle(sql, fut);
    }));
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @param handler the result handler
   * @return self
   */
  public io.vertx.rxjava.ext.sql.SQLOperations querySingleWithParams(String sql, JsonArray arguments, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.querySingleWithParams(sql, arguments, handler);
    return this;
  }

    /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   * @deprecated use {@link #rxQuerySingleWithParams} instead
   */
  @Deprecated()
  public Observable<JsonArray> querySingleWithParamsObservable(String sql, JsonArray arguments) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    querySingleWithParams(sql, arguments, handler.toHandler());
    return handler;
  }

  /**
   * Execute a one shot SQL statement with arguments that returns a single SQL row. This method will reduce the
   * boilerplate code by getting a connection from the pool (this object) and return it back after the execution.
   * Only the first result from the result set is returned.
   * @param sql the statement to execute
   * @param arguments the arguments
   * @return self
   */
  public Single<JsonArray> rxQuerySingleWithParams(String sql, JsonArray arguments) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      querySingleWithParams(sql, arguments, fut);
    }));
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations update(String sql, Handler<AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler) { 
    delegate.update(sql, resultHandler);
    return this;
  }

    /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   * @deprecated use {@link #rxUpdate} instead
   */
  @Deprecated()
  public Observable<io.vertx.ext.sql.UpdateResult> updateObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.ext.sql.UpdateResult> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    update(sql, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Executes the given SQL statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement.
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @return 
   */
  public Single<io.vertx.ext.sql.UpdateResult> rxUpdate(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      update(sql, fut);
    }));
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @param resultHandler the handler which is called once the operation completes.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations updateWithParams(String sql, JsonArray params, Handler<AsyncResult<io.vertx.ext.sql.UpdateResult>> resultHandler) { 
    delegate.updateWithParams(sql, params, resultHandler);
    return this;
  }

    /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   * @deprecated use {@link #rxUpdateWithParams} instead
   */
  @Deprecated()
  public Observable<io.vertx.ext.sql.UpdateResult> updateWithParamsObservable(String sql, JsonArray params) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.ext.sql.UpdateResult> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    updateWithParams(sql, params, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Executes the given prepared statement which may be an <code>INSERT</code>, <code>UPDATE</code>, or <code>DELETE</code>
   * statement with the given parameters
   * @param sql the SQL to execute. For example <code>INSERT INTO table ...</code>
   * @param params these are the parameters to fill the statement.
   * @return 
   */
  public Single<io.vertx.ext.sql.UpdateResult> rxUpdateWithParams(String sql, JsonArray params) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      updateWithParams(sql, params, fut);
    }));
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations call(String sql, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.call(sql, resultHandler);
    return this;
  }

    /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   * @deprecated use {@link #rxCall} instead
   */
  @Deprecated()
  public Observable<io.vertx.ext.sql.ResultSet> callObservable(String sql) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.ext.sql.ResultSet> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    call(sql, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   * @param sql the SQL to execute. For example <code>{call getEmpName}</code>.
   * @return 
   */
  public Single<io.vertx.ext.sql.ResultSet> rxCall(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      call(sql, fut);
    }));
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @param resultHandler the handler which is called once the operation completes. It will return a <code>ResultSet</code>.
   * @return 
   */
  public io.vertx.rxjava.ext.sql.SQLOperations callWithParams(String sql, JsonArray params, JsonArray outputs, Handler<AsyncResult<io.vertx.ext.sql.ResultSet>> resultHandler) { 
    delegate.callWithParams(sql, params, outputs, resultHandler);
    return this;
  }

    /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   * @deprecated use {@link #rxCallWithParams} instead
   */
  @Deprecated()
  public Observable<io.vertx.ext.sql.ResultSet> callWithParamsObservable(String sql, JsonArray params, JsonArray outputs) { 
    io.vertx.rx.java.ObservableFuture<io.vertx.ext.sql.ResultSet> resultHandler = io.vertx.rx.java.RxHelper.observableFuture();
    callWithParams(sql, params, outputs, resultHandler.toHandler());
    return resultHandler;
  }

  /**
   * Calls the given SQL <code>PROCEDURE</code> which returns the result from the procedure.
   *
   * The index of params and outputs are important for both arrays, for example when dealing with a prodecure that
   * takes the first 2 arguments as input values and the 3 arg as an output then the arrays should be like:
   *
   * <pre>
   *   params = [VALUE1, VALUE2, null]
   *   outputs = [null, null, "VARCHAR"]
   * </pre>
   * @param sql the SQL to execute. For example <code>{call getEmpName (?, ?)}</code>.
   * @param params these are the parameters to fill the statement.
   * @param outputs these are the outputs to fill the statement.
   * @return 
   */
  public Single<io.vertx.ext.sql.ResultSet> rxCallWithParams(String sql, JsonArray params, JsonArray outputs) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      callWithParams(sql, params, outputs, fut);
    }));
  }

}
