/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A handler which decodes cookies from the request, makes them available in the 
 * and writes them back in the response.
 *
 * Since 3.8.1 this handler simply calls the next request handler. This handler will be removed in Vert.x 4.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CookieHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.CookieHandler.class)
public class CookieHandler implements Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CookieHandler that = (CookieHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<CookieHandler> __TYPE_ARG = new TypeArg<>(    obj -> new CookieHandler((io.vertx.ext.web.handler.CookieHandler) obj),
    CookieHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CookieHandler delegate;
  
  public CookieHandler(io.vertx.ext.web.handler.CookieHandler delegate) {
    this.delegate = delegate;
  }

  public CookieHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CookieHandler)delegate;
  }

  public io.vertx.ext.web.handler.CookieHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  @Deprecated()
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Create a cookie handler
   * @return the cookie handler
   */
  @Deprecated()
  public static io.vertx.rxjava.ext.web.handler.CookieHandler create() { 
    io.vertx.rxjava.ext.web.handler.CookieHandler ret = io.vertx.rxjava.ext.web.handler.CookieHandler.newInstance((io.vertx.ext.web.handler.CookieHandler)io.vertx.ext.web.handler.CookieHandler.create());
    return ret;
  }

  public static CookieHandler newInstance(io.vertx.ext.web.handler.CookieHandler arg) {
    return arg != null ? new CookieHandler(arg) : null;
  }

}
