/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.handler;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * A handler which renders responses using a template engine and where the template name is selected from the URI
 * path.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.TemplateHandler original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.handler.TemplateHandler.class)
public class TemplateHandler implements Handler<io.vertx.rxjava.ext.web.RoutingContext> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TemplateHandler that = (TemplateHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<TemplateHandler> __TYPE_ARG = new TypeArg<>(    obj -> new TemplateHandler((io.vertx.ext.web.handler.TemplateHandler) obj),
    TemplateHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.TemplateHandler delegate;
  
  public TemplateHandler(io.vertx.ext.web.handler.TemplateHandler delegate) {
    this.delegate = delegate;
  }

  public TemplateHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.TemplateHandler)delegate;
  }

  public io.vertx.ext.web.handler.TemplateHandler getDelegate() {
    return delegate;
  }

  /**
   * Something has happened, so handle it.
   * @param event the event to handle
   */
  public void handle(io.vertx.rxjava.ext.web.RoutingContext event) { 
    delegate.handle(event.getDelegate());
  }

  /**
   * Set the index template
   * @param indexTemplate the index template
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.ext.web.handler.TemplateHandler setIndexTemplate(String indexTemplate) { 
    delegate.setIndexTemplate(indexTemplate);
    return this;
  }

  /**
   * Create a handler
   * @param engine the template engine
   * @return the handler
   */
  public static io.vertx.rxjava.ext.web.handler.TemplateHandler create(io.vertx.rxjava.ext.web.common.template.TemplateEngine engine) { 
    io.vertx.rxjava.ext.web.handler.TemplateHandler ret = io.vertx.rxjava.ext.web.handler.TemplateHandler.newInstance((io.vertx.ext.web.handler.TemplateHandler)io.vertx.ext.web.handler.TemplateHandler.create(engine.getDelegate()));
    return ret;
  }

  /**
   * Create a handler
   * @param engine the template engine
   * @param templateDirectory the template directory where templates will be looked for
   * @param contentType the content type header to be used in the response
   * @return the handler
   */
  public static io.vertx.rxjava.ext.web.handler.TemplateHandler create(io.vertx.rxjava.ext.web.common.template.TemplateEngine engine, String templateDirectory, String contentType) { 
    io.vertx.rxjava.ext.web.handler.TemplateHandler ret = io.vertx.rxjava.ext.web.handler.TemplateHandler.newInstance((io.vertx.ext.web.handler.TemplateHandler)io.vertx.ext.web.handler.TemplateHandler.create(engine.getDelegate(), templateDirectory, contentType));
    return ret;
  }

  /**
   * The default directory where templates will be looked for
   */
  public static final String DEFAULT_TEMPLATE_DIRECTORY = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_TEMPLATE_DIRECTORY;
  /**
   * The default content type header to be used in the response
   */
  public static final String DEFAULT_CONTENT_TYPE = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_CONTENT_TYPE;
  /**
   * The default index page
   */
  public static final String DEFAULT_INDEX_TEMPLATE = io.vertx.ext.web.handler.TemplateHandler.DEFAULT_INDEX_TEMPLATE;
  public static TemplateHandler newInstance(io.vertx.ext.web.handler.TemplateHandler arg) {
    return arg != null ? new TemplateHandler(arg) : null;
  }

}
