/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.ext.web.templ.pebble;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A template engine that uses the Pebble library.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.pebble.PebbleTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.class)
public class PebbleTemplateEngine extends io.vertx.rxjava.ext.web.common.template.TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PebbleTemplateEngine that = (PebbleTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PebbleTemplateEngine> __TYPE_ARG = new TypeArg<>(    obj -> new PebbleTemplateEngine((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine) obj),
    PebbleTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.pebble.PebbleTemplateEngine delegate;
  
  public PebbleTemplateEngine(io.vertx.ext.web.templ.pebble.PebbleTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public PebbleTemplateEngine(Object delegate) {
    super((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)delegate);
    this.delegate = (io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)delegate;
  }

  public io.vertx.ext.web.templ.pebble.PebbleTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static io.vertx.rxjava.ext.web.templ.pebble.PebbleTemplateEngine create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.ext.web.templ.pebble.PebbleTemplateEngine ret = io.vertx.rxjava.ext.web.templ.pebble.PebbleTemplateEngine.newInstance((io.vertx.ext.web.templ.pebble.PebbleTemplateEngine)io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param extension the extension
   * @return a reference to this for fluency
   */
  @Deprecated()
  public io.vertx.rxjava.ext.web.templ.pebble.PebbleTemplateEngine setExtension(String extension) { 
    delegate.setExtension(extension);
    return this;
  }

  /**
   * Set the max cache size for the engine
   * @param maxCacheSize the maxCacheSize
   * @return a reference to this for fluency
   */
  public io.vertx.rxjava.ext.web.templ.pebble.PebbleTemplateEngine setMaxCacheSize(int maxCacheSize) { 
    delegate.setMaxCacheSize(maxCacheSize);
    return this;
  }

  /**
   * Default max number of templates to cache
   */
  public static final int DEFAULT_MAX_CACHE_SIZE = io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.DEFAULT_MAX_CACHE_SIZE;
  /**
   * Default template extension
   */
  public static final String DEFAULT_TEMPLATE_EXTENSION = io.vertx.ext.web.templ.pebble.PebbleTemplateEngine.DEFAULT_TEMPLATE_EXTENSION;
  public static PebbleTemplateEngine newInstance(io.vertx.ext.web.templ.pebble.PebbleTemplateEngine arg) {
    return arg != null ? new PebbleTemplateEngine(arg) : null;
  }

}
