/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.mysqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A connection to MySQL server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.mysqlclient.MySQLConnection original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.mysqlclient.MySQLConnection.class)
public class MySQLConnection extends io.vertx.rxjava.sqlclient.SqlConnection {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MySQLConnection that = (MySQLConnection) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<MySQLConnection> __TYPE_ARG = new TypeArg<>(    obj -> new MySQLConnection((io.vertx.mysqlclient.MySQLConnection) obj),
    MySQLConnection::getDelegate
  );

  private final io.vertx.mysqlclient.MySQLConnection delegate;
  
  public MySQLConnection(io.vertx.mysqlclient.MySQLConnection delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public MySQLConnection(Object delegate) {
    super((io.vertx.mysqlclient.MySQLConnection)delegate);
    this.delegate = (io.vertx.mysqlclient.MySQLConnection)delegate;
  }

  public io.vertx.mysqlclient.MySQLConnection getDelegate() {
    return delegate;
  }

  /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @param handler the handler called with the connection or the failure
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions, Handler<AsyncResult<io.vertx.rxjava.mysqlclient.MySQLConnection>> handler) { 
    io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectOptions, new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>() {
      public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Create a connection to MySQL server with the given <code>connectOptions</code>.
   * @param vertx the vertx instance
   * @param connectOptions the options for the connection
   * @return 
   */
  public static Single<io.vertx.rxjava.mysqlclient.MySQLConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, io.vertx.mysqlclient.MySQLConnectOptions connectOptions) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectOptions, fut);
    }));
  }

  /**
   * Like {@link io.vertx.rxjava.mysqlclient.MySQLConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @param handler 
   */
  public static void connect(io.vertx.rxjava.core.Vertx vertx, String connectionUri, Handler<AsyncResult<io.vertx.rxjava.mysqlclient.MySQLConnection>> handler) { 
    io.vertx.mysqlclient.MySQLConnection.connect(vertx.getDelegate(), connectionUri, new Handler<AsyncResult<io.vertx.mysqlclient.MySQLConnection>>() {
      public void handle(AsyncResult<io.vertx.mysqlclient.MySQLConnection> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.mysqlclient.MySQLConnection.newInstance((io.vertx.mysqlclient.MySQLConnection)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Like {@link io.vertx.rxjava.mysqlclient.MySQLConnection#connect} with options build from <code>connectionUri</code>.
   * @param vertx 
   * @param connectionUri 
   * @return 
   */
  public static Single<io.vertx.rxjava.mysqlclient.MySQLConnection> rxConnect(io.vertx.rxjava.core.Vertx vertx, String connectionUri) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      connect(vertx, connectionUri, fut);
    }));
  }

  public io.vertx.rxjava.mysqlclient.MySQLConnection prepare(String sql, Handler<AsyncResult<io.vertx.rxjava.sqlclient.PreparedStatement>> handler) { 
    delegate.prepare(sql, new Handler<AsyncResult<io.vertx.sqlclient.PreparedStatement>>() {
      public void handle(AsyncResult<io.vertx.sqlclient.PreparedStatement> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.sqlclient.PreparedStatement.newInstance((io.vertx.sqlclient.PreparedStatement)ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
    return this;
  }

    public Single<io.vertx.rxjava.sqlclient.PreparedStatement> rxPrepare(String sql) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      prepare(sql, fut);
    }));
  }

  public io.vertx.rxjava.mysqlclient.MySQLConnection exceptionHandler(Handler<java.lang.Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.rxjava.mysqlclient.MySQLConnection closeHandler(Handler<Void> handler) { 
    delegate.closeHandler(handler);
    return this;
  }

  /**
   * Send a PING command to check if the server is alive.
   * @param handler the handler notified when the server responses to client
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection ping(Handler<AsyncResult<Void>> handler) { 
    delegate.ping(handler);
    return this;
  }

    /**
   * Send a PING command to check if the server is alive.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxPing() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      ping(fut);
    }));
  }

  /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection specifySchema(String schemaName, Handler<AsyncResult<Void>> handler) { 
    delegate.specifySchema(schemaName, handler);
    return this;
  }

    /**
   * Send a INIT_DB command to change the default schema of the connection.
   * @param schemaName name of the schema to change to
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxSpecifySchema(String schemaName) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      specifySchema(schemaName, fut);
    }));
  }

  /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> handler) { 
    delegate.getInternalStatistics(handler);
    return this;
  }

    /**
   * Send a STATISTICS command to get a human readable string of the server internal status.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<String> rxGetInternalStatistics() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getInternalStatistics(fut);
    }));
  }

  /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection setOption(io.vertx.mysqlclient.MySQLSetOption option, Handler<AsyncResult<Void>> handler) { 
    delegate.setOption(option, handler);
    return this;
  }

    /**
   * Send a SET_OPTION command to set options for the current connection.
   * @param option the options to set
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxSetOption(io.vertx.mysqlclient.MySQLSetOption option) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      setOption(option, fut);
    }));
  }

  /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection resetConnection(Handler<AsyncResult<Void>> handler) { 
    delegate.resetConnection(handler);
    return this;
  }

    /**
   * Send a RESET_CONNECTION command to reset the session state.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxResetConnection() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      resetConnection(fut);
    }));
  }

  /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @param handler the handler notified with the execution result
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection debug(Handler<AsyncResult<Void>> handler) { 
    delegate.debug(handler);
    return this;
  }

    /**
   * Send a DEBUG command to dump debug information to the server's stdout.
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxDebug() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      debug(fut);
    }));
  }

  /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   */
  public io.vertx.rxjava.mysqlclient.MySQLConnection changeUser(io.vertx.mysqlclient.MySQLAuthOptions options, Handler<AsyncResult<Void>> handler) { 
    delegate.changeUser(options, handler);
    return this;
  }

    /**
   * Send a CHANGE_USER command to change the user of the current connection, this operation will also reset connection state.
   * @param options authentication options
   * @return a reference to this, so the API can be used fluently
   */
  public Single<Void> rxChangeUser(io.vertx.mysqlclient.MySQLAuthOptions options) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      changeUser(options, fut);
    }));
  }

  public static MySQLConnection newInstance(io.vertx.mysqlclient.MySQLConnection arg) {
    return arg != null ? new MySQLConnection(arg) : null;
  }

}
