/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.rabbitmq;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Like {@link com.rabbitmq.client.BasicProperties}
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.BasicProperties original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.BasicProperties.class)
public class BasicProperties {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    BasicProperties that = (BasicProperties) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<BasicProperties> __TYPE_ARG = new TypeArg<>(    obj -> new BasicProperties((io.vertx.rabbitmq.BasicProperties) obj),
    BasicProperties::getDelegate
  );

  private final io.vertx.rabbitmq.BasicProperties delegate;
  
  public BasicProperties(io.vertx.rabbitmq.BasicProperties delegate) {
    this.delegate = delegate;
  }

  public BasicProperties(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.BasicProperties)delegate;
  }

  public io.vertx.rabbitmq.BasicProperties getDelegate() {
    return delegate;
  }

  /**
   * @return contentType of a message, or <code>null</code> if it has not been set.
   */
  public String contentType() { 
    if (cached_0 != null) {
      return cached_0;
    }
    String ret = delegate.contentType();
    cached_0 = ret;
    return ret;
  }

  /**
   * @return contentEncoding of a message, or <code>null</code> if it has not been set.
   */
  public String contentEncoding() { 
    if (cached_1 != null) {
      return cached_1;
    }
    String ret = delegate.contentEncoding();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return deliveryMode of a message, or <code>null</code> if it has not been set.
   */
  public Integer deliveryMode() { 
    if (cached_2 != null) {
      return cached_2;
    }
    Integer ret = delegate.deliveryMode();
    cached_2 = ret;
    return ret;
  }

  /**
   * Retrieve the value in the priority field.
   * @return priority of a message, or <code>null</code> if it has not been set.
   */
  public Integer priority() { 
    if (cached_3 != null) {
      return cached_3;
    }
    Integer ret = delegate.priority();
    cached_3 = ret;
    return ret;
  }

  /**
   * @return correlationId of a message, or <code>null</code> if it has not been set.
   */
  public String correlationId() { 
    if (cached_4 != null) {
      return cached_4;
    }
    String ret = delegate.correlationId();
    cached_4 = ret;
    return ret;
  }

  /**
   * @return replyTo address, or <code>null</code> if it has not been set.
   */
  public String replyTo() { 
    if (cached_5 != null) {
      return cached_5;
    }
    String ret = delegate.replyTo();
    cached_5 = ret;
    return ret;
  }

  /**
   * @return expiration of a message, or <code>null</code> if it has not been set.
   */
  public String expiration() { 
    if (cached_6 != null) {
      return cached_6;
    }
    String ret = delegate.expiration();
    cached_6 = ret;
    return ret;
  }

  /**
   * @return messageId, or <code>null</code> if it has not been set.
   */
  public String messageId() { 
    if (cached_7 != null) {
      return cached_7;
    }
    String ret = delegate.messageId();
    cached_7 = ret;
    return ret;
  }

  /**
   * @return timestamp of a message, or <code>null</code> if it has not been set.
   */
  public Long timestamp() { 
    if (cached_8 != null) {
      return cached_8;
    }
    Long ret = delegate.timestamp();
    cached_8 = ret;
    return ret;
  }

  /**
   * @return type of a message, or <code>null</code> if it has not been set.
   */
  public String type() { 
    if (cached_9 != null) {
      return cached_9;
    }
    String ret = delegate.type();
    cached_9 = ret;
    return ret;
  }

  /**
   * @return userId, or <code>null</code> if it has not been set.
   */
  public String userId() { 
    if (cached_10 != null) {
      return cached_10;
    }
    String ret = delegate.userId();
    cached_10 = ret;
    return ret;
  }

  /**
   * @return appId, or <code>null</code> if it has not been set.
   */
  public String appId() { 
    if (cached_11 != null) {
      return cached_11;
    }
    String ret = delegate.appId();
    cached_11 = ret;
    return ret;
  }

  /**
   * @return clusterId, or <code>null</code> if it has not been set.
   */
  public String clusterId() { 
    if (cached_12 != null) {
      return cached_12;
    }
    String ret = delegate.clusterId();
    cached_12 = ret;
    return ret;
  }

  private String cached_0;
  private String cached_1;
  private Integer cached_2;
  private Integer cached_3;
  private String cached_4;
  private String cached_5;
  private String cached_6;
  private String cached_7;
  private Long cached_8;
  private String cached_9;
  private String cached_10;
  private String cached_11;
  private String cached_12;
  public static BasicProperties newInstance(io.vertx.rabbitmq.BasicProperties arg) {
    return arg != null ? new BasicProperties(arg) : null;
  }

}
