/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.rabbitmq;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Represent a message received message received in a rabbitmq-queue.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.rabbitmq.RabbitMQMessage original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.rabbitmq.RabbitMQMessage.class)
public class RabbitMQMessage {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RabbitMQMessage that = (RabbitMQMessage) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RabbitMQMessage> __TYPE_ARG = new TypeArg<>(    obj -> new RabbitMQMessage((io.vertx.rabbitmq.RabbitMQMessage) obj),
    RabbitMQMessage::getDelegate
  );

  private final io.vertx.rabbitmq.RabbitMQMessage delegate;
  
  public RabbitMQMessage(io.vertx.rabbitmq.RabbitMQMessage delegate) {
    this.delegate = delegate;
  }

  public RabbitMQMessage(Object delegate) {
    this.delegate = (io.vertx.rabbitmq.RabbitMQMessage)delegate;
  }

  public io.vertx.rabbitmq.RabbitMQMessage getDelegate() {
    return delegate;
  }

  /**
   * @return the message body
   */
  public io.vertx.rxjava.core.buffer.Buffer body() { 
    if (cached_0 != null) {
      return cached_0;
    }
    io.vertx.rxjava.core.buffer.Buffer ret = io.vertx.rxjava.core.buffer.Buffer.newInstance((io.vertx.core.buffer.Buffer)delegate.body());
    cached_0 = ret;
    return ret;
  }

  /**
   * @return the <i>consumer tag</i> associated with the consumer
   */
  public String consumerTag() { 
    if (cached_1 != null) {
      return cached_1;
    }
    String ret = delegate.consumerTag();
    cached_1 = ret;
    return ret;
  }

  /**
   * @return packaging data for the message
   */
  public io.vertx.rxjava.rabbitmq.Envelope envelope() { 
    if (cached_2 != null) {
      return cached_2;
    }
    io.vertx.rxjava.rabbitmq.Envelope ret = io.vertx.rxjava.rabbitmq.Envelope.newInstance((io.vertx.rabbitmq.Envelope)delegate.envelope());
    cached_2 = ret;
    return ret;
  }

  /**
   * @return content header data for the message
   */
  public io.vertx.rxjava.rabbitmq.BasicProperties properties() { 
    if (cached_3 != null) {
      return cached_3;
    }
    io.vertx.rxjava.rabbitmq.BasicProperties ret = io.vertx.rxjava.rabbitmq.BasicProperties.newInstance((io.vertx.rabbitmq.BasicProperties)delegate.properties());
    cached_3 = ret;
    return ret;
  }

  private io.vertx.rxjava.core.buffer.Buffer cached_0;
  private String cached_1;
  private io.vertx.rxjava.rabbitmq.Envelope cached_2;
  private io.vertx.rxjava.rabbitmq.BasicProperties cached_3;
  public static RabbitMQMessage newInstance(io.vertx.rabbitmq.RabbitMQMessage arg) {
    return arg != null ? new RabbitMQMessage(arg) : null;
  }

}
