/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.redis.sentinel;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * This factory is deprecated use {@link io.vertx.rxjava.redis.client.Redis} instead,
 * or for a typed API {@link io.vertx.rxjava.redis.client.RedisAPI}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.redis.sentinel.RedisSentinel original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.redis.sentinel.RedisSentinel.class)
public class RedisSentinel {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RedisSentinel that = (RedisSentinel) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<RedisSentinel> __TYPE_ARG = new TypeArg<>(    obj -> new RedisSentinel((io.vertx.redis.sentinel.RedisSentinel) obj),
    RedisSentinel::getDelegate
  );

  private final io.vertx.redis.sentinel.RedisSentinel delegate;
  
  public RedisSentinel(io.vertx.redis.sentinel.RedisSentinel delegate) {
    this.delegate = delegate;
  }

  public RedisSentinel(Object delegate) {
    this.delegate = (io.vertx.redis.sentinel.RedisSentinel)delegate;
  }

  public io.vertx.redis.sentinel.RedisSentinel getDelegate() {
    return delegate;
  }

  public static io.vertx.rxjava.redis.sentinel.RedisSentinel create(io.vertx.rxjava.core.Vertx vertx) { 
    io.vertx.rxjava.redis.sentinel.RedisSentinel ret = io.vertx.rxjava.redis.sentinel.RedisSentinel.newInstance((io.vertx.redis.sentinel.RedisSentinel)io.vertx.redis.sentinel.RedisSentinel.create(vertx.getDelegate()));
    return ret;
  }

  public static io.vertx.rxjava.redis.sentinel.RedisSentinel create(io.vertx.rxjava.core.Vertx vertx, JsonObject config) { 
    io.vertx.rxjava.redis.sentinel.RedisSentinel ret = io.vertx.rxjava.redis.sentinel.RedisSentinel.newInstance((io.vertx.redis.sentinel.RedisSentinel)io.vertx.redis.sentinel.RedisSentinel.create(vertx.getDelegate(), config));
    return ret;
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @param handler 
   */
  public void close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

    /**
   * Close the client - when it is fully closed the handler will be called.
   * @return 
   * @deprecated use {@link #rxClose} instead
   */
  @Deprecated()
  public Observable<Void> closeObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    close(handler.toHandler());
    return handler;
  }

  /**
   * Close the client - when it is fully closed the handler will be called.
   * @return 
   */
  public Single<Void> rxClose() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      close(fut);
    }));
  }

  /**
   * Show a list of monitored masters and their state
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel masters(Handler<AsyncResult<JsonArray>> handler) { 
    delegate.masters(handler);
    return this;
  }

    /**
   * Show a list of monitored masters and their state
   * @return 
   * @deprecated use {@link #rxMasters} instead
   */
  @Deprecated()
  public Observable<JsonArray> mastersObservable() { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    masters(handler.toHandler());
    return handler;
  }

  /**
   * Show a list of monitored masters and their state
   * @return 
   */
  public Single<JsonArray> rxMasters() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      masters(fut);
    }));
  }

  /**
   * Show the state and info of the specified master
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel master(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.master(name, handler);
    return this;
  }

    /**
   * Show the state and info of the specified master
   * @param name master name
   * @return 
   * @deprecated use {@link #rxMaster} instead
   */
  @Deprecated()
  public Observable<JsonArray> masterObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    master(name, handler.toHandler());
    return handler;
  }

  /**
   * Show the state and info of the specified master
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxMaster(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      master(name, fut);
    }));
  }

  /**
   * Show a list of slaves for this master, and their state
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel slaves(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.slaves(name, handler);
    return this;
  }

    /**
   * Show a list of slaves for this master, and their state
   * @param name master name
   * @return 
   * @deprecated use {@link #rxSlaves} instead
   */
  @Deprecated()
  public Observable<JsonArray> slavesObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    slaves(name, handler.toHandler());
    return handler;
  }

  /**
   * Show a list of slaves for this master, and their state
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxSlaves(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      slaves(name, fut);
    }));
  }

  /**
   * Show a list of sentinel instances for this master, and their state
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel sentinels(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.sentinels(name, handler);
    return this;
  }

    /**
   * Show a list of sentinel instances for this master, and their state
   * @param name master name
   * @return 
   * @deprecated use {@link #rxSentinels} instead
   */
  @Deprecated()
  public Observable<JsonArray> sentinelsObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    sentinels(name, handler.toHandler());
    return handler;
  }

  /**
   * Show a list of sentinel instances for this master, and their state
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxSentinels(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      sentinels(name, fut);
    }));
  }

  /**
   * Return the ip and port number of the master with that name.
   * If a failover is in progress or terminated successfully for this master
   * it returns the address and port of the promoted slave
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel getMasterAddrByName(String name, Handler<AsyncResult<JsonArray>> handler) { 
    delegate.getMasterAddrByName(name, handler);
    return this;
  }

    /**
   * Return the ip and port number of the master with that name.
   * If a failover is in progress or terminated successfully for this master
   * it returns the address and port of the promoted slave
   * @param name master name
   * @return 
   * @deprecated use {@link #rxGetMasterAddrByName} instead
   */
  @Deprecated()
  public Observable<JsonArray> getMasterAddrByNameObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<JsonArray> handler = io.vertx.rx.java.RxHelper.observableFuture();
    getMasterAddrByName(name, handler.toHandler());
    return handler;
  }

  /**
   * Return the ip and port number of the master with that name.
   * If a failover is in progress or terminated successfully for this master
   * it returns the address and port of the promoted slave
   * @param name master name
   * @return 
   */
  public Single<JsonArray> rxGetMasterAddrByName(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getMasterAddrByName(name, fut);
    }));
  }

  /**
   * Reset all the masters with matching name.
   * The pattern argument is a glob-style pattern.
   * The reset process clears any previous state in a master (including a failover in pro
   * @param pattern pattern String
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel reset(String pattern, Handler<AsyncResult<Void>> handler) { 
    delegate.reset(pattern, handler);
    return this;
  }

    /**
   * Reset all the masters with matching name.
   * The pattern argument is a glob-style pattern.
   * The reset process clears any previous state in a master (including a failover in pro
   * @param pattern pattern String
   * @return 
   * @deprecated use {@link #rxReset} instead
   */
  @Deprecated()
  public Observable<Void> resetObservable(String pattern) { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    reset(pattern, handler.toHandler());
    return handler;
  }

  /**
   * Reset all the masters with matching name.
   * The pattern argument is a glob-style pattern.
   * The reset process clears any previous state in a master (including a failover in pro
   * @param pattern pattern String
   * @return 
   */
  public Single<Void> rxReset(String pattern) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      reset(pattern, fut);
    }));
  }

  /**
   * Force a failover as if the master was not reachable, and without asking for agreement to other Sentinels
   * (however a new version of the configuration will be published so that the other Sentinels
   * will update their configurations)
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel failover(String name, Handler<AsyncResult<String>> handler) { 
    delegate.failover(name, handler);
    return this;
  }

    /**
   * Force a failover as if the master was not reachable, and without asking for agreement to other Sentinels
   * (however a new version of the configuration will be published so that the other Sentinels
   * will update their configurations)
   * @param name master name
   * @return 
   * @deprecated use {@link #rxFailover} instead
   */
  @Deprecated()
  public Observable<String> failoverObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<String> handler = io.vertx.rx.java.RxHelper.observableFuture();
    failover(name, handler.toHandler());
    return handler;
  }

  /**
   * Force a failover as if the master was not reachable, and without asking for agreement to other Sentinels
   * (however a new version of the configuration will be published so that the other Sentinels
   * will update their configurations)
   * @param name master name
   * @return 
   */
  public Single<String> rxFailover(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      failover(name, fut);
    }));
  }

  /**
   * Check if the current Sentinel configuration is able to reach the quorum needed to failover a master,
   * and the majority needed to authorize the failover. This command should be used in monitoring systems
   * to check if a Sentinel deployment is ok.
   * @param name master name
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel ckquorum(String name, Handler<AsyncResult<String>> handler) { 
    delegate.ckquorum(name, handler);
    return this;
  }

    /**
   * Check if the current Sentinel configuration is able to reach the quorum needed to failover a master,
   * and the majority needed to authorize the failover. This command should be used in monitoring systems
   * to check if a Sentinel deployment is ok.
   * @param name master name
   * @return 
   * @deprecated use {@link #rxCkquorum} instead
   */
  @Deprecated()
  public Observable<String> ckquorumObservable(String name) { 
    io.vertx.rx.java.ObservableFuture<String> handler = io.vertx.rx.java.RxHelper.observableFuture();
    ckquorum(name, handler.toHandler());
    return handler;
  }

  /**
   * Check if the current Sentinel configuration is able to reach the quorum needed to failover a master,
   * and the majority needed to authorize the failover. This command should be used in monitoring systems
   * to check if a Sentinel deployment is ok.
   * @param name master name
   * @return 
   */
  public Single<String> rxCkquorum(String name) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      ckquorum(name, fut);
    }));
  }

  /**
   * Force Sentinel to rewrite its configuration on disk, including the current Sentinel state.
   * Normally Sentinel rewrites the configuration every time something changes in its state
   * (in the context of the subset of the state which is persisted on disk across restart).
   * However sometimes it is possible that the configuration file is lost because of operation errors,
   * disk failures, package upgrade scripts or configuration managers. In those cases a way to to force Sentinel to
   * rewrite the configuration file is handy. This command works even if the previous configuration file
   * is completely missing.
   * @param handler Handler for the result of this call
   * @return 
   */
  public io.vertx.rxjava.redis.sentinel.RedisSentinel flushConfig(Handler<AsyncResult<Void>> handler) { 
    delegate.flushConfig(handler);
    return this;
  }

    /**
   * Force Sentinel to rewrite its configuration on disk, including the current Sentinel state.
   * Normally Sentinel rewrites the configuration every time something changes in its state
   * (in the context of the subset of the state which is persisted on disk across restart).
   * However sometimes it is possible that the configuration file is lost because of operation errors,
   * disk failures, package upgrade scripts or configuration managers. In those cases a way to to force Sentinel to
   * rewrite the configuration file is handy. This command works even if the previous configuration file
   * is completely missing.
   * @return 
   * @deprecated use {@link #rxFlushConfig} instead
   */
  @Deprecated()
  public Observable<Void> flushConfigObservable() { 
    io.vertx.rx.java.ObservableFuture<Void> handler = io.vertx.rx.java.RxHelper.observableFuture();
    flushConfig(handler.toHandler());
    return handler;
  }

  /**
   * Force Sentinel to rewrite its configuration on disk, including the current Sentinel state.
   * Normally Sentinel rewrites the configuration every time something changes in its state
   * (in the context of the subset of the state which is persisted on disk across restart).
   * However sometimes it is possible that the configuration file is lost because of operation errors,
   * disk failures, package upgrade scripts or configuration managers. In those cases a way to to force Sentinel to
   * rewrite the configuration file is handy. This command works even if the previous configuration file
   * is completely missing.
   * @return 
   */
  public Single<Void> rxFlushConfig() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      flushConfig(fut);
    }));
  }

  public static RedisSentinel newInstance(io.vertx.redis.sentinel.RedisSentinel arg) {
    return arg != null ? new RedisSentinel(arg) : null;
  }

}
