/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.servicediscovery.types;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.servicediscovery.types.JDBCDataSource original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.servicediscovery.types.JDBCDataSource.class)
public class JDBCDataSource {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JDBCDataSource that = (JDBCDataSource) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<JDBCDataSource> __TYPE_ARG = new TypeArg<>(    obj -> new JDBCDataSource((io.vertx.servicediscovery.types.JDBCDataSource) obj),
    JDBCDataSource::getDelegate
  );

  private final io.vertx.servicediscovery.types.JDBCDataSource delegate;
  
  public JDBCDataSource(io.vertx.servicediscovery.types.JDBCDataSource delegate) {
    this.delegate = delegate;
  }

  public JDBCDataSource(Object delegate) {
    this.delegate = (io.vertx.servicediscovery.types.JDBCDataSource)delegate;
  }

  public io.vertx.servicediscovery.types.JDBCDataSource getDelegate() {
    return delegate;
  }

  public static io.vertx.servicediscovery.Record createRecord(String name, JsonObject location, JsonObject metadata) { 
    io.vertx.servicediscovery.Record ret = io.vertx.servicediscovery.types.JDBCDataSource.createRecord(name, location, metadata);
    return ret;
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param resultHandler The result handler
   */
  public static void getJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, JsonObject filter, Handler<AsyncResult<io.vertx.rxjava.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @return 
   */
  public static Single<io.vertx.rxjava.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, JsonObject filter) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getJDBCClient(discovery, filter, fut);
    }));
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @param resultHandler The result handler
   */
  public static void getJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, Handler<AsyncResult<io.vertx.rxjava.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter (must not be <code>null</code>)
   * @return 
   */
  public static Single<io.vertx.rxjava.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getJDBCClient(discovery, filter, fut);
    }));
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @param resultHandler the result handler
   */
  public static void getJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration, Handler<AsyncResult<io.vertx.rxjava.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, optional
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static Single<io.vertx.rxjava.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, JsonObject filter, JsonObject consumerConfiguration) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getJDBCClient(discovery, filter, consumerConfiguration, fut);
    }));
  }

  /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @param resultHandler the result handler
   */
  public static void getJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration, Handler<AsyncResult<io.vertx.rxjava.ext.jdbc.JDBCClient>> resultHandler) { 
    io.vertx.servicediscovery.types.JDBCDataSource.getJDBCClient(discovery.getDelegate(), filter, consumerConfiguration, new Handler<AsyncResult<io.vertx.ext.jdbc.JDBCClient>>() {
      public void handle(AsyncResult<io.vertx.ext.jdbc.JDBCClient> ar) {
        if (ar.succeeded()) {
          resultHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.rxjava.ext.jdbc.JDBCClient.newInstance((io.vertx.ext.jdbc.JDBCClient)ar.result())));
        } else {
          resultHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Convenient method that looks for a JDBC datasource source and provides the configured {@link io.vertx.rxjava.ext.jdbc.JDBCClient}. The
   * async result is marked as failed is there are no matching services, or if the lookup fails.
   * @param discovery The service discovery instance
   * @param filter The filter, must not be <code>null</code>
   * @param consumerConfiguration the consumer configuration
   * @return 
   */
  public static Single<io.vertx.rxjava.ext.jdbc.JDBCClient> rxGetJDBCClient(io.vertx.rxjava.servicediscovery.ServiceDiscovery discovery, Function<io.vertx.servicediscovery.Record, Boolean> filter, JsonObject consumerConfiguration) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      getJDBCClient(discovery, filter, consumerConfiguration, fut);
    }));
  }

  /**
   * Unknown type.
   */
  public static final String UNKNOWN = io.vertx.servicediscovery.types.JDBCDataSource.UNKNOWN;
  public static final String TYPE = io.vertx.servicediscovery.types.JDBCDataSource.TYPE;
  public static JDBCDataSource newInstance(io.vertx.servicediscovery.types.JDBCDataSource arg) {
    return arg != null ? new JDBCDataSource(arg) : null;
  }

}
