/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A query for a prepared statement allowing parameterized execution of the query, this query will use
 * a prepared statement.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.PreparedQuery original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.PreparedQuery.class)
public class PreparedQuery<T> extends io.vertx.rxjava.sqlclient.Query<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreparedQuery that = (PreparedQuery) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<PreparedQuery> __TYPE_ARG = new TypeArg<>(    obj -> new PreparedQuery((io.vertx.sqlclient.PreparedQuery) obj),
    PreparedQuery::getDelegate
  );

  private final io.vertx.sqlclient.PreparedQuery<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public PreparedQuery(io.vertx.sqlclient.PreparedQuery delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public PreparedQuery(Object delegate, TypeArg<T> typeArg_0) {
    super((io.vertx.sqlclient.PreparedQuery)delegate);
    this.delegate = (io.vertx.sqlclient.PreparedQuery)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.PreparedQuery getDelegate() {
    return delegate;
  }


  /**
   * Execute the query.
   * @param handler the handler receiving the response
   */
  public void execute(Handler<AsyncResult<T>> handler) { 
    delegate.execute(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Execute the query.
   * @return 
   */
  public Single<T> rxExecute() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      execute(fut);
    }));
  }

  /**
   * Execute the query.
   * @param tuple 
   * @param handler the handler receiving the response
   */
  public void execute(io.vertx.rxjava.sqlclient.Tuple tuple, Handler<AsyncResult<T>> handler) { 
    delegate.execute(tuple.getDelegate(), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Execute the query.
   * @param tuple 
   * @return 
   */
  public Single<T> rxExecute(io.vertx.rxjava.sqlclient.Tuple tuple) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      execute(tuple, fut);
    }));
  }

  /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   * @param handler the handler receiving the response
   */
  public void executeBatch(List<io.vertx.rxjava.sqlclient.Tuple> batch, Handler<AsyncResult<T>> handler) { 
    delegate.executeBatch(batch.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Execute the query with a batch of tuples.
   * @param batch the batch of tuples
   * @return 
   */
  public Single<T> rxExecuteBatch(List<io.vertx.rxjava.sqlclient.Tuple> batch) { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      executeBatch(batch, fut);
    }));
  }

  /**
   * Use the specified <code>mapper</code> for mapping {@link io.vertx.rxjava.sqlclient.Row} to <code><U></code>.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.rxjava.sqlclient.PreparedQuery<io.vertx.rxjava.sqlclient.RowSet<U>> mapping(Function<io.vertx.rxjava.sqlclient.Row, U> mapper) { 
    io.vertx.rxjava.sqlclient.PreparedQuery<io.vertx.rxjava.sqlclient.RowSet<U>> ret = io.vertx.rxjava.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.mapping(new Function<io.vertx.sqlclient.Row,U>() {
      public U apply(io.vertx.sqlclient.Row arg) {
        U ret = mapper.apply(io.vertx.rxjava.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)arg));
        return ret;
      }
    }), new TypeArg<io.vertx.rxjava.sqlclient.RowSet<U>>(o0 -> io.vertx.rxjava.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.unknown()), o0 -> o0.getDelegate()));
    return ret;
  }

  public static <T> PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg) {
    return arg != null ? new PreparedQuery<T>(arg) : null;
  }

  public static <T> PreparedQuery<T> newInstance(io.vertx.sqlclient.PreparedQuery arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new PreparedQuery<T>(arg, __typeArg_T) : null;
  }

}
