/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * A query.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Query original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.Query.class)
public class Query<T> {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Query that = (Query) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<Query> __TYPE_ARG = new TypeArg<>(    obj -> new Query((io.vertx.sqlclient.Query) obj),
    Query::getDelegate
  );

  private final io.vertx.sqlclient.Query<T> delegate;
  public final TypeArg<T> __typeArg_0;
  
  public Query(io.vertx.sqlclient.Query delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = TypeArg.unknown();  }

  public Query(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.Query)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public io.vertx.sqlclient.Query getDelegate() {
    return delegate;
  }


  /**
   * Execute the query.
   * @param handler the handler receiving the response
   */
  public void execute(Handler<AsyncResult<T>> handler) { 
    delegate.execute(new Handler<AsyncResult<T>>() {
      public void handle(AsyncResult<T> ar) {
        if (ar.succeeded()) {
          handler.handle(io.vertx.core.Future.succeededFuture((T)__typeArg_0.wrap(ar.result())));
        } else {
          handler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    });
  }

    /**
   * Execute the query.
   * @return 
   */
  public Single<T> rxExecute() { 
    return Single.create(new io.vertx.rx.java.SingleOnSubscribeAdapter<>(fut -> {
      execute(fut);
    }));
  }

  /**
   * Use the specified <code>mapper</code> for mapping {@link io.vertx.rxjava.sqlclient.Row} to <code><U></code>.
   * @param mapper 
   * @return 
   */
  public <U> io.vertx.rxjava.sqlclient.Query<io.vertx.rxjava.sqlclient.RowSet<U>> mapping(Function<io.vertx.rxjava.sqlclient.Row, U> mapper) { 
    io.vertx.rxjava.sqlclient.Query<io.vertx.rxjava.sqlclient.RowSet<U>> ret = io.vertx.rxjava.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.mapping(new Function<io.vertx.sqlclient.Row,U>() {
      public U apply(io.vertx.sqlclient.Row arg) {
        U ret = mapper.apply(io.vertx.rxjava.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)arg));
        return ret;
      }
    }), new TypeArg<io.vertx.rxjava.sqlclient.RowSet<U>>(o0 -> io.vertx.rxjava.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o0, TypeArg.unknown()), o0 -> o0.getDelegate()));
    return ret;
  }

  public static <T> Query<T> newInstance(io.vertx.sqlclient.Query arg) {
    return arg != null ? new Query<T>(arg) : null;
  }

  public static <T> Query<T> newInstance(io.vertx.sqlclient.Query arg, TypeArg<T> __typeArg_T) {
    return arg != null ? new Query<T>(arg, __typeArg_T) : null;
  }

}
