/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.rxjava.sqlclient;

import rx.Observable;
import rx.Single;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.WriteStreamSubscriber;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import java.util.Map;
import java.util.Set;
import java.util.List;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import io.vertx.core.Handler;
import io.vertx.core.AsyncResult;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.lang.rx.MappingIterator;

/**
 * Defines the client operations with a database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlClient original} non RX-ified interface using Vert.x codegen.
 */

@RxGen(io.vertx.sqlclient.SqlClient.class)
public class SqlClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlClient that = (SqlClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final TypeArg<SqlClient> __TYPE_ARG = new TypeArg<>(    obj -> new SqlClient((io.vertx.sqlclient.SqlClient) obj),
    SqlClient::getDelegate
  );

  private final io.vertx.sqlclient.SqlClient delegate;
  
  public SqlClient(io.vertx.sqlclient.SqlClient delegate) {
    this.delegate = delegate;
  }

  public SqlClient(Object delegate) {
    this.delegate = (io.vertx.sqlclient.SqlClient)delegate;
  }

  public io.vertx.sqlclient.SqlClient getDelegate() {
    return delegate;
  }

  private static final TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>>(o1 -> io.vertx.rxjava.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.rxjava.sqlclient.Row>(o2 -> io.vertx.rxjava.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  private static final TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> TYPE_ARG_1 = new TypeArg<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>>(o1 -> io.vertx.rxjava.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.rxjava.sqlclient.Row>(o2 -> io.vertx.rxjava.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());

  /**
   * Create a query, the {@link io.vertx.rxjava.sqlclient.Query#execute} method must be called to execute the query.
   * @param sql 
   * @return the query
   */
  public io.vertx.rxjava.sqlclient.Query<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> query(String sql) { 
    io.vertx.rxjava.sqlclient.Query<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> ret = io.vertx.rxjava.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * Create a prepared query, one of the {@link io.vertx.rxjava.sqlclient.Query#execute} or {@link io.vertx.rxjava.sqlclient.PreparedQuery#executeBatch}
   * methods must be called to execute the query.
   * @param sql 
   * @return the prepared query
   */
  public io.vertx.rxjava.sqlclient.PreparedQuery<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> preparedQuery(String sql) { 
    io.vertx.rxjava.sqlclient.PreparedQuery<io.vertx.rxjava.sqlclient.RowSet<io.vertx.rxjava.sqlclient.Row>> ret = io.vertx.rxjava.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * Close the client and release the associated resources.
   */
  public void close() { 
    delegate.close();
  }

  public static SqlClient newInstance(io.vertx.sqlclient.SqlClient arg) {
    return arg != null ? new SqlClient(arg) : null;
  }

}
