/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.shell.command;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.ext.shell.command.Command;
import io.vertx.rxjava.ext.shell.command.CommandResolver;
import java.util.List;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.ext.shell.command.CommandRegistry.class)
public class CommandRegistry
extends CommandResolver {
    public static final TypeArg<CommandRegistry> __TYPE_ARG = new TypeArg(obj -> new CommandRegistry((io.vertx.ext.shell.command.CommandRegistry)obj), CommandRegistry::getDelegate);
    private final io.vertx.ext.shell.command.CommandRegistry delegate;

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandRegistry that = (CommandRegistry)o;
        return this.delegate.equals(that.delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public CommandRegistry(io.vertx.ext.shell.command.CommandRegistry delegate) {
        super((io.vertx.ext.shell.command.CommandResolver)delegate);
        this.delegate = delegate;
    }

    public CommandRegistry(Object delegate) {
        super((io.vertx.ext.shell.command.CommandResolver)((io.vertx.ext.shell.command.CommandRegistry)delegate));
        this.delegate = (io.vertx.ext.shell.command.CommandRegistry)delegate;
    }

    public io.vertx.ext.shell.command.CommandRegistry getDelegate() {
        return this.delegate;
    }

    public static CommandRegistry getShared(io.vertx.rxjava.core.Vertx vertx) {
        CommandRegistry ret = CommandRegistry.newInstance(io.vertx.ext.shell.command.CommandRegistry.getShared((Vertx)vertx.getDelegate()));
        return ret;
    }

    public static CommandRegistry create(io.vertx.rxjava.core.Vertx vertx) {
        CommandRegistry ret = CommandRegistry.newInstance(io.vertx.ext.shell.command.CommandRegistry.create((Vertx)vertx.getDelegate()));
        return ret;
    }

    public CommandRegistry registerCommand(Command command) {
        this.delegate.registerCommand(command.getDelegate());
        return this;
    }

    public CommandRegistry registerCommand(Command command, final Handler<AsyncResult<Command>> completionHandler) {
        this.delegate.registerCommand(command.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.ext.shell.command.Command>>(){

            public void handle(AsyncResult<io.vertx.ext.shell.command.Command> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture((Object)Command.newInstance((io.vertx.ext.shell.command.Command)ar.result())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<Command> registerCommandObservable(Command command) {
        ObservableFuture<Command> completionHandler = RxHelper.observableFuture();
        this.registerCommand(command, completionHandler.toHandler());
        return completionHandler;
    }

    public Single<Command> rxRegisterCommand(Command command) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.registerCommand(command, (Handler<AsyncResult<Command>>)fut)));
    }

    public CommandRegistry registerCommands(List<Command> commands) {
        this.delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()));
        return this;
    }

    public CommandRegistry registerCommands(List<Command> commands, final Handler<AsyncResult<List<Command>>> completionHandler) {
        this.delegate.registerCommands(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.ext.shell.command.Command>>>(){

            public void handle(AsyncResult<List<io.vertx.ext.shell.command.Command>> ar) {
                if (ar.succeeded()) {
                    completionHandler.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Command.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    completionHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<List<Command>> registerCommandsObservable(List<Command> commands) {
        ObservableFuture<List<Command>> completionHandler = RxHelper.observableFuture();
        this.registerCommands(commands, completionHandler.toHandler());
        return completionHandler;
    }

    public Single<List<Command>> rxRegisterCommands(List<Command> commands) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.registerCommands(commands, (Handler<AsyncResult<List<Command>>>)fut)));
    }

    public CommandRegistry unregisterCommand(String commandName) {
        this.delegate.unregisterCommand(commandName);
        return this;
    }

    public CommandRegistry unregisterCommand(String commandName, Handler<AsyncResult<Void>> completionHandler) {
        this.delegate.unregisterCommand(commandName, completionHandler);
        return this;
    }

    @Deprecated
    public Observable<Void> unregisterCommandObservable(String commandName) {
        ObservableFuture<Void> completionHandler = RxHelper.observableFuture();
        this.unregisterCommand(commandName, completionHandler.toHandler());
        return completionHandler;
    }

    public Single<Void> rxUnregisterCommand(String commandName) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.unregisterCommand(commandName, (Handler<AsyncResult<Void>>)fut)));
    }

    public static CommandRegistry newInstance(io.vertx.ext.shell.command.CommandRegistry arg) {
        return arg != null ? new CommandRegistry(arg) : null;
    }
}

