/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.redis.client;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rx.java.SingleOnSubscribeAdapter;
import io.vertx.rxjava.core.streams.Pipe;
import io.vertx.rxjava.core.streams.ReadStream;
import io.vertx.rxjava.core.streams.WriteStream;
import io.vertx.rxjava.redis.client.Request;
import io.vertx.rxjava.redis.client.Response;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import rx.Observable;
import rx.Single;

@RxGen(value=io.vertx.redis.client.RedisConnection.class)
public class RedisConnection
implements ReadStream<Response> {
    public static final TypeArg<RedisConnection> __TYPE_ARG = new TypeArg(obj -> new RedisConnection((io.vertx.redis.client.RedisConnection)obj), RedisConnection::getDelegate);
    private final io.vertx.redis.client.RedisConnection delegate;
    private Observable<Response> observable;
    private static final TypeArg<Response> TYPE_ARG_0 = new TypeArg(o1 -> Response.newInstance((io.vertx.redis.client.Response)o1), o1 -> o1.getDelegate());

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConnection that = (RedisConnection)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisConnection(io.vertx.redis.client.RedisConnection delegate) {
        this.delegate = delegate;
    }

    public RedisConnection(Object delegate) {
        this.delegate = (io.vertx.redis.client.RedisConnection)delegate;
    }

    public io.vertx.redis.client.RedisConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public synchronized Observable<Response> toObservable() {
        if (this.observable == null) {
            Function<io.vertx.redis.client.Response, Response> conv = Response::newInstance;
            this.observable = RxHelper.toObservable(this.delegate, conv);
        }
        return this.observable;
    }

    @Override
    public Pipe<Response> pipe() {
        Pipe<Response> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    public void pipeTo(WriteStream<Response> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    @Override
    public void pipeTo(WriteStream<Response> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Deprecated
    public Observable<Void> pipeToObservable(WriteStream<Response> dst) {
        ObservableFuture<Void> handler = RxHelper.observableFuture();
        this.pipeTo(dst, (Handler<AsyncResult<Void>>)handler.toHandler());
        return handler;
    }

    public Single<Void> rxPipeTo(WriteStream<Response> dst) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.pipeTo(dst, (Handler<AsyncResult<Void>>)fut)));
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public RedisConnection handler(final Handler<Response> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.redis.client.Response>(){

            public void handle(io.vertx.redis.client.Response event) {
                handler.handle((Object)Response.newInstance(event));
            }
        });
        return this;
    }

    public RedisConnection pause() {
        this.delegate.pause();
        return this;
    }

    public RedisConnection resume() {
        this.delegate.resume();
        return this;
    }

    public RedisConnection fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    public RedisConnection endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler(endHandler);
        return this;
    }

    public RedisConnection send(Request command, final Handler<AsyncResult<Response>> onSend) {
        this.delegate.send(command.getDelegate(), (Handler)new Handler<AsyncResult<io.vertx.redis.client.Response>>(){

            public void handle(AsyncResult<io.vertx.redis.client.Response> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture((Object)Response.newInstance((io.vertx.redis.client.Response)ar.result())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<Response> sendObservable(Request command) {
        ObservableFuture<Response> onSend = RxHelper.observableFuture();
        this.send(command, onSend.toHandler());
        return onSend;
    }

    public Single<Response> rxSend(Request command) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.send(command, (Handler<AsyncResult<Response>>)fut)));
    }

    public RedisConnection batch(List<Request> commands, final Handler<AsyncResult<List<Response>>> onSend) {
        this.delegate.batch(commands.stream().map(elt -> elt.getDelegate()).collect(Collectors.toList()), (Handler)new Handler<AsyncResult<List<io.vertx.redis.client.Response>>>(){

            public void handle(AsyncResult<List<io.vertx.redis.client.Response>> ar) {
                if (ar.succeeded()) {
                    onSend.handle((Object)Future.succeededFuture(((List)ar.result()).stream().map(elt -> Response.newInstance(elt)).collect(Collectors.toList())));
                } else {
                    onSend.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    @Deprecated
    public Observable<List<Response>> batchObservable(List<Request> commands) {
        ObservableFuture<List<Response>> onSend = RxHelper.observableFuture();
        this.batch(commands, onSend.toHandler());
        return onSend;
    }

    public Single<List<Response>> rxBatch(List<Request> commands) {
        return Single.create(new SingleOnSubscribeAdapter(fut -> this.batch(commands, (Handler<AsyncResult<List<Response>>>)fut)));
    }

    public void close() {
        this.delegate.close();
    }

    public boolean pendingQueueFull() {
        boolean ret = this.delegate.pendingQueueFull();
        return ret;
    }

    public static RedisConnection newInstance(io.vertx.redis.client.RedisConnection arg) {
        return arg != null ? new RedisConnection(arg) : null;
    }
}

