/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.servicediscovery;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.servicediscovery.ServiceReference;
import io.vertx.reactivex.servicediscovery.spi.ServiceExporter;
import io.vertx.reactivex.servicediscovery.spi.ServiceImporter;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscoveryOptions;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@RxGen(value=io.vertx.servicediscovery.ServiceDiscovery.class)
public class ServiceDiscovery {
    public static final TypeArg<ServiceDiscovery> __TYPE_ARG = new TypeArg(obj -> new ServiceDiscovery((io.vertx.servicediscovery.ServiceDiscovery)obj), ServiceDiscovery::getDelegate);
    private final io.vertx.servicediscovery.ServiceDiscovery delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDiscovery that = (ServiceDiscovery)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public ServiceDiscovery(io.vertx.servicediscovery.ServiceDiscovery delegate) {
        this.delegate = delegate;
    }

    public io.vertx.servicediscovery.ServiceDiscovery getDelegate() {
        return this.delegate;
    }

    public static ServiceDiscovery create(Vertx vertx, ServiceDiscoveryOptions options) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate(), options));
        return ret;
    }

    public static ServiceDiscovery create(Vertx vertx) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate()));
        return ret;
    }

    public static ServiceDiscovery create(Vertx vertx, ServiceDiscoveryOptions options, final Handler<ServiceDiscovery> completionHandler) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate(), options, new Handler<io.vertx.servicediscovery.ServiceDiscovery>(){

            public void handle(io.vertx.servicediscovery.ServiceDiscovery event) {
                completionHandler.handle((Object)ServiceDiscovery.newInstance(event));
            }
        }));
        return ret;
    }

    public static ServiceDiscovery create(Vertx vertx, final Handler<ServiceDiscovery> completionHandler) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(io.vertx.servicediscovery.ServiceDiscovery.create(vertx.getDelegate(), new Handler<io.vertx.servicediscovery.ServiceDiscovery>(){

            public void handle(io.vertx.servicediscovery.ServiceDiscovery event) {
                completionHandler.handle((Object)ServiceDiscovery.newInstance(event));
            }
        }));
        return ret;
    }

    public ServiceReference getReference(Record record) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReference(record));
        return ret;
    }

    public ServiceReference getReferenceWithConfiguration(Record record, JsonObject configuration) {
        ServiceReference ret = ServiceReference.newInstance(this.delegate.getReferenceWithConfiguration(record, configuration));
        return ret;
    }

    public boolean release(ServiceReference reference) {
        boolean ret = this.delegate.release(reference.getDelegate());
        return ret;
    }

    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(this.delegate.registerServiceImporter(importer.getDelegate(), configuration));
        return ret;
    }

    public ServiceDiscovery registerServiceImporter(ServiceImporter importer, JsonObject configuration, Handler<AsyncResult<Void>> completionHandler) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(this.delegate.registerServiceImporter(importer.getDelegate(), configuration, completionHandler));
        return ret;
    }

    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(this.delegate.registerServiceExporter(exporter.getDelegate(), configuration));
        return ret;
    }

    public ServiceDiscovery registerServiceExporter(ServiceExporter exporter, JsonObject configuration, Handler<AsyncResult<Void>> completionHandler) {
        ServiceDiscovery ret = ServiceDiscovery.newInstance(this.delegate.registerServiceExporter(exporter.getDelegate(), configuration, completionHandler));
        return ret;
    }

    public void close() {
        this.delegate.close();
    }

    public void publish(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.publish(record, resultHandler);
    }

    public Single<Record> rxPublish(Record record) {
        return new AsyncResultSingle(handler -> this.publish(record, (Handler<AsyncResult<Record>>)handler));
    }

    public void unpublish(String id, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.unpublish(id, resultHandler);
    }

    public Completable rxUnpublish(String id) {
        return new AsyncResultCompletable(handler -> this.unpublish(id, (Handler<AsyncResult<Void>>)handler));
    }

    public void getRecord(JsonObject filter, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(filter, resultHandler);
    }

    public Single<Record> rxGetRecord(JsonObject filter) {
        return new AsyncResultSingle(handler -> this.getRecord(filter, (Handler<AsyncResult<Record>>)handler));
    }

    public void getRecord(final Function<Record, Boolean> filter, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, resultHandler);
    }

    public Single<Record> rxGetRecord(Function<Record, Boolean> filter) {
        return new AsyncResultSingle(handler -> this.getRecord(filter, (Handler<AsyncResult<Record>>)handler));
    }

    public void getRecord(final Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.getRecord(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, includeOutOfService, resultHandler);
    }

    public Single<Record> rxGetRecord(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return new AsyncResultSingle(handler -> this.getRecord(filter, includeOutOfService, (Handler<AsyncResult<Record>>)handler));
    }

    public void getRecords(JsonObject filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(filter, resultHandler);
    }

    public Single<List<Record>> rxGetRecords(JsonObject filter) {
        return new AsyncResultSingle(handler -> this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)handler));
    }

    public void getRecords(final Function<Record, Boolean> filter, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, resultHandler);
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter) {
        return new AsyncResultSingle(handler -> this.getRecords(filter, (Handler<AsyncResult<List<Record>>>)handler));
    }

    public void getRecords(final Function<Record, Boolean> filter, boolean includeOutOfService, Handler<AsyncResult<List<Record>>> resultHandler) {
        this.delegate.getRecords(new Function<Record, Boolean>(){

            @Override
            public Boolean apply(Record arg) {
                Boolean ret = (Boolean)filter.apply(arg);
                return ret;
            }
        }, includeOutOfService, resultHandler);
    }

    public Single<List<Record>> rxGetRecords(Function<Record, Boolean> filter, boolean includeOutOfService) {
        return new AsyncResultSingle(handler -> this.getRecords(filter, includeOutOfService, (Handler<AsyncResult<List<Record>>>)handler));
    }

    public void update(Record record, Handler<AsyncResult<Record>> resultHandler) {
        this.delegate.update(record, resultHandler);
    }

    public Single<Record> rxUpdate(Record record) {
        return new AsyncResultSingle(handler -> this.update(record, (Handler<AsyncResult<Record>>)handler));
    }

    public Set<ServiceReference> bindings() {
        Set<ServiceReference> ret = this.delegate.bindings().stream().map(elt -> ServiceReference.newInstance(elt)).collect(Collectors.toSet());
        return ret;
    }

    public ServiceDiscoveryOptions options() {
        ServiceDiscoveryOptions ret = this.delegate.options();
        return ret;
    }

    public static void releaseServiceObject(ServiceDiscovery discovery, Object svcObject) {
        io.vertx.servicediscovery.ServiceDiscovery.releaseServiceObject(discovery.getDelegate(), svcObject);
    }

    public static ServiceDiscovery newInstance(io.vertx.servicediscovery.ServiceDiscovery arg) {
        return arg != null ? new ServiceDiscovery(arg) : null;
    }
}

