/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types.impl;

import io.vertx.core.Vertx;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.servicediscovery.types.AbstractServiceReference;
import io.vertx.servicediscovery.types.MessageSource;
import java.util.Objects;

public class MessageSourceImpl
implements MessageSource {
    public static final String TYPE = "message-source";

    @Override
    public String name() {
        return TYPE;
    }

    @Override
    public ServiceReference get(Vertx vertx, ServiceDiscovery discovery, Record record, JsonObject configuration) {
        Objects.requireNonNull(vertx);
        Objects.requireNonNull(record);
        Objects.requireNonNull(discovery);
        return new MessageSourceReference(vertx, discovery, record);
    }

    private class MessageSourceReference<X>
    extends AbstractServiceReference<MessageConsumer<X>> {
        MessageSourceReference(Vertx vertx, ServiceDiscovery discovery, Record record) {
            super(vertx, discovery, record);
        }

        @Override
        public MessageConsumer<X> retrieve() {
            return this.vertx.eventBus().consumer(this.record().getLocation().getString("endpoint"));
        }

        @Override
        protected void onClose() {
            ((MessageConsumer)this.service).unregister();
        }
    }
}

