/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.servicediscovery.types;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.types.HttpLocationConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class HttpLocation {
    private String host;
    private int port;
    private String root = "";
    private String endpoint;
    private boolean ssl = false;

    public HttpLocation() {
    }

    public HttpLocation(HttpLocation other) {
        this.host = other.host;
        this.port = other.port;
        this.root = other.root;
        this.ssl = other.ssl;
    }

    public HttpLocation(JsonObject json) {
        this();
        HttpLocationConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        HttpLocationConverter.toJson(this, json);
        return json;
    }

    public String getHost() {
        return this.host;
    }

    public HttpLocation setHost(String host) {
        this.host = host;
        this.updateLocation();
        return this;
    }

    public HttpLocation setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public int getPort() {
        return this.port;
    }

    public HttpLocation setPort(int port) {
        this.port = port;
        this.updateLocation();
        return this;
    }

    public String getRoot() {
        this.updateLocation();
        return this.root;
    }

    public HttpLocation setRoot(String root) {
        this.root = root.startsWith("/") ? root : "/" + root;
        this.updateLocation();
        return this;
    }

    private void updateLocation() {
        this.setEndpoint("http" + (this.isSsl() ? "s" : "") + "://" + this.host + ":" + this.port + this.root);
    }

    public HttpLocation setSsl(boolean ssl) {
        this.ssl = ssl;
        this.updateLocation();
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }
}

