/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.serviceproxy;

import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;
import io.vertx.serviceproxy.ServiceException;

public class ServiceExceptionMessageCodec
implements MessageCodec<ServiceException, ServiceException> {
    public void encodeToWire(Buffer buffer, ServiceException body) {
        buffer.appendInt(body.failureCode());
        if (body.getMessage() == null) {
            buffer.appendByte((byte)0);
        } else {
            buffer.appendByte((byte)1);
            byte[] encoded = body.getMessage().getBytes(CharsetUtil.UTF_8);
            buffer.appendInt(encoded.length);
            buffer.appendBytes(encoded);
        }
        body.getDebugInfo().writeToBuffer(buffer);
    }

    public ServiceException decodeFromWire(int pos, Buffer buffer) {
        String message;
        int failureCode = buffer.getInt(pos);
        boolean isNull = buffer.getByte(pos += 4) == 0;
        ++pos;
        if (!isNull) {
            int strLength = buffer.getInt(pos);
            byte[] bytes = buffer.getBytes(pos += 4, pos + strLength);
            message = new String(bytes, CharsetUtil.UTF_8);
            pos += strLength;
        } else {
            message = null;
        }
        JsonObject debugInfo = new JsonObject();
        debugInfo.readFromBuffer(pos, buffer);
        return new ServiceException(failureCode, message, debugInfo);
    }

    public ServiceException transform(ServiceException exception) {
        return exception;
    }

    public String name() {
        return "ServiceException";
    }

    public byte systemCodecID() {
        return -1;
    }
}

