/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.netty.util.internal.StringUtil;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.List;
import java.util.stream.Collectors;

@Name(value="bus-tail")
@Summary(value="Subscribe to one or several event bus address and logs received messages on the console")
public class BusTail
extends AnnotatedCommand {
    private List<String> addresses;
    private boolean verbose;
    private boolean local;

    @Argument(index=0, argName="address")
    @Description(value="the bus address destination")
    public void setAddresses(List<String> addresses) {
        this.addresses = addresses;
    }

    @Option(longName="verbose", flag=true)
    @Description(value="verbose output")
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Option(longName="local", flag=true)
    @Description(value="subscribe to a local address")
    public void setLocal(boolean local) {
        this.local = local;
    }

    @Override
    public void process(CommandProcess process) {
        EventBus eb = process.vertx().eventBus();
        List consumers = this.addresses.stream().map(address -> {
            Handler consumer = msg -> {
                Object body = msg.body();
                String bodyString = body instanceof Buffer ? StringUtil.toHexString((byte[])((Buffer)body).getBytes()) : String.valueOf(body);
                if (this.verbose) {
                    process.write(address + ":\n");
                    process.write("Reply address: " + msg.replyAddress() + "\n");
                    MultiMap headers = msg.headers();
                    for (String header : headers.names()) {
                        process.write("Header " + header + ":" + headers.getAll(header) + "\n");
                    }
                    process.write(bodyString + "\n");
                } else {
                    process.write(address + ":" + bodyString + "\n");
                }
            };
            return this.local ? eb.localConsumer(address, consumer) : eb.consumer(address, consumer);
        }).collect(Collectors.toList());
        process.interruptHandler((Handler<Void>)((Handler)done -> process.end()));
        process.endHandler((Handler<Void>)((Handler)done -> consumers.forEach(MessageConsumer::unregister)));
    }
}

