/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.base;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import java.io.PrintWriter;
import java.io.StringWriter;

@Name(value="verticle-deploy")
@Summary(value="Deploy a verticle")
public class VerticleDeploy
extends AnnotatedCommand {
    private String name;
    private String options;
    private DeploymentOptions deploymentOptions;

    @Argument(index=0, argName="name")
    @Description(value="the verticle name")
    public void setName(String name) {
        this.name = name;
    }

    @Argument(index=1, argName="options", required=false)
    @Description(value="the verticle deployment options as JSON string")
    public void setOptions(String options) {
        this.options = options;
    }

    protected DeploymentOptions getDeploymentOptions() {
        return this.options != null && !this.options.isEmpty() ? new DeploymentOptions(new JsonObject(this.options)) : new DeploymentOptions();
    }

    @Override
    public void process(CommandProcess process) {
        try {
            this.deploymentOptions = this.getDeploymentOptions();
        }
        catch (RuntimeException e) {
            process.write("Could not deploy " + this.name + " with deployment options\n");
            StringWriter buffer = new StringWriter();
            PrintWriter writer = new PrintWriter(buffer);
            e.printStackTrace(writer);
            process.write(buffer.toString()).end();
            return;
        }
        process.vertx().deployVerticle(this.name, this.deploymentOptions, ar -> {
            if (ar.succeeded()) {
                process.write("Deployed " + (String)ar.result() + "\n").end();
            } else {
                process.write("Could not deploy " + this.name + "\n");
                StringWriter buffer = new StringWriter();
                PrintWriter writer = new PrintWriter(buffer);
                ar.cause().printStackTrace(writer);
                process.write(buffer.toString()).end();
            }
        });
    }
}

