/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.shell.command.impl;

import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.cli.CLI;
import io.vertx.ext.shell.cli.CliToken;
import io.vertx.ext.shell.cli.Completion;
import io.vertx.ext.shell.command.Command;
import io.vertx.ext.shell.command.CommandBuilder;
import io.vertx.ext.shell.command.CommandProcess;
import io.vertx.ext.shell.command.impl.ProcessImpl;
import io.vertx.ext.shell.system.Process;
import java.util.Collections;
import java.util.List;

public class CommandBuilderImpl
implements CommandBuilder {
    final String name;
    final CLI cli;
    public Handler<CommandProcess> processHandler;
    public Handler<Completion> completeHandler;

    public CommandBuilderImpl(String name, CLI cli) {
        this.name = name;
        this.cli = cli;
    }

    @Override
    public CommandBuilderImpl processHandler(Handler<CommandProcess> handler) {
        this.processHandler = handler;
        return this;
    }

    @Override
    public CommandBuilderImpl completionHandler(Handler<Completion> handler) {
        this.completeHandler = handler;
        return this;
    }

    @Override
    public Command build(final Vertx vertx) {
        final Context context = vertx.getOrCreateContext();
        return new Command(){

            @Override
            public String name() {
                return CommandBuilderImpl.this.name;
            }

            @Override
            public CLI cli() {
                return CommandBuilderImpl.this.cli;
            }

            @Override
            public Process createProcess(List<CliToken> args) {
                return new ProcessImpl(vertx, context, this, args, CommandBuilderImpl.this.processHandler);
            }

            @Override
            public void complete(Completion completion) {
                if (CommandBuilderImpl.this.completeHandler != null) {
                    context.runOnContext(v -> {
                        try {
                            CommandBuilderImpl.this.completeHandler.handle((Object)completion);
                        }
                        catch (Throwable t) {
                            completion.complete(Collections.emptyList());
                            throw t;
                        }
                    });
                } else {
                    Command.super.complete(completion);
                }
            }
        };
    }
}

