/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient;

import io.vertx.core.json.JsonObject;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.LinkedHashMap;
import java.util.Map;

public class SqlConnectOptionsConverter {
    public static void fromJson(Iterable<Map.Entry<String, Object>> json, SqlConnectOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "cachePreparedStatements": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setCachePreparedStatements((Boolean)member.getValue());
                    break;
                }
                case "database": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setDatabase((String)member.getValue());
                    break;
                }
                case "host": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setHost((String)member.getValue());
                    break;
                }
                case "password": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setPassword((String)member.getValue());
                    break;
                }
                case "port": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPort(((Number)member.getValue()).intValue());
                    break;
                }
                case "preparedStatementCacheMaxSize": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPreparedStatementCacheMaxSize(((Number)member.getValue()).intValue());
                    break;
                }
                case "preparedStatementCacheSqlLimit": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setPreparedStatementCacheSqlLimit(((Number)member.getValue()).intValue());
                    break;
                }
                case "properties": {
                    if (!(member.getValue() instanceof JsonObject)) break;
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    ((Iterable)member.getValue()).forEach(entry -> {
                        if (entry.getValue() instanceof String) {
                            map.put((String)entry.getKey(), (String)entry.getValue());
                        }
                    });
                    obj.setProperties(map);
                    break;
                }
                case "user": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setUser((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(SqlConnectOptions obj, JsonObject json) {
        SqlConnectOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(SqlConnectOptions obj, Map<String, Object> json) {
        json.put("cachePreparedStatements", obj.getCachePreparedStatements());
        if (obj.getDatabase() != null) {
            json.put("database", obj.getDatabase());
        }
        if (obj.getHost() != null) {
            json.put("host", obj.getHost());
        }
        if (obj.getPassword() != null) {
            json.put("password", obj.getPassword());
        }
        json.put("port", obj.getPort());
        json.put("preparedStatementCacheMaxSize", obj.getPreparedStatementCacheMaxSize());
        json.put("preparedStatementCacheSqlLimit", obj.getPreparedStatementCacheSqlLimit());
        if (obj.getProperties() != null) {
            JsonObject map = new JsonObject();
            obj.getProperties().forEach((key, value) -> map.put(key, value));
            json.put("properties", map);
        }
        if (obj.getUser() != null) {
            json.put("user", obj.getUser());
        }
    }
}

