/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sql;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sql.ResultSetConverter;
import java.util.ArrayList;
import java.util.List;

@DataObject(generateConverter=true)
public class ResultSet {
    private List<String> columnNames;
    private List<JsonArray> results;
    private List<JsonObject> rows;
    private JsonArray output;
    private ResultSet next;

    public ResultSet() {
    }

    public ResultSet(ResultSet other) {
        this.columnNames = other.columnNames;
        this.results = other.results;
        this.output = other.output;
        this.next = other.next;
    }

    public ResultSet(List<String> columnNames, List<JsonArray> results, ResultSet next) {
        this.columnNames = columnNames;
        this.results = results;
        this.next = next;
    }

    public ResultSet(JsonObject json) {
        ResultSetConverter.fromJson(json, this);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        ResultSetConverter.toJson(this, obj);
        return obj;
    }

    public List<JsonArray> getResults() {
        return this.results;
    }

    public ResultSet setResults(List<JsonArray> results) {
        this.results = results;
        return this;
    }

    public JsonArray getOutput() {
        return this.output;
    }

    public ResultSet setOutput(JsonArray output) {
        this.output = output;
        return this;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public ResultSet setColumnNames(List<String> columnNames) {
        this.columnNames = columnNames;
        return this;
    }

    public ResultSet getNext() {
        return this.next;
    }

    public ResultSet setNext(ResultSet next) {
        this.next = next;
        return this;
    }

    public List<JsonObject> getRows() {
        if (this.rows == null) {
            this.rows = new ArrayList<JsonObject>(this.results.size());
            int cols = this.columnNames.size();
            for (JsonArray result : this.results) {
                JsonObject row = new JsonObject();
                for (int i = 0; i < cols; ++i) {
                    row.put(this.columnNames.get(i), result.getValue(i));
                }
                this.rows.add(row);
            }
        }
        return this.rows;
    }

    public int getNumRows() {
        return this.results.size();
    }

    public int getNumColumns() {
        return this.columnNames.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultSet resultSet = (ResultSet)o;
        if (this.columnNames != null ? !this.columnNames.equals(resultSet.columnNames) : resultSet.columnNames != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(resultSet.results) : resultSet.results != null) {
            return false;
        }
        return !(this.next != null ? !this.next.equals(resultSet.next) : resultSet.next != null);
    }

    public int hashCode() {
        int result = this.columnNames != null ? this.columnNames.hashCode() : 0;
        result = 31 * result + (this.results != null ? this.results.hashCode() : 0);
        result = 31 * result + (this.next != null ? this.next.hashCode() : 0);
        return result;
    }
}

