/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ParameterLocation;
import io.vertx.ext.web.api.validation.ParameterType;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ParameterValidationRule;
import io.vertx.ext.web.api.validation.ValidationException;
import java.util.List;

public class ParameterValidationRuleImpl
implements ParameterValidationRule {
    private String name;
    ParameterTypeValidator validator;
    private ParameterLocation location;
    private boolean isOptional;
    private boolean allowEmptyValue;

    public ParameterValidationRuleImpl(String name, ParameterTypeValidator validator, boolean isOptional, boolean allowEmptyValue, ParameterLocation location) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
        if (validator == null) {
            throw new IllegalArgumentException("validator cannot be null");
        }
        this.validator = validator;
        this.isOptional = isOptional;
        this.allowEmptyValue = allowEmptyValue;
        this.location = location;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected RequestParameter callValidator(String value) throws ValidationException {
        try {
            RequestParameter result = this.validator.isValid(value);
            if (result.getName() == null) {
                result.setName(this.getName());
            }
            return result;
        }
        catch (ValidationException e) {
            e.setParameterName(this.name);
            e.setValidationRule(this);
            e.setValue(value);
            throw e;
        }
    }

    protected RequestParameter callValidator(List<String> value) throws ValidationException {
        try {
            RequestParameter result = this.validator.isValidCollection(value);
            if (result.getName() == null) {
                result.setName(this.getName());
            }
            return result;
        }
        catch (ValidationException e) {
            e.setParameterName(this.name);
            e.setValidationRule(this);
            e.setValue(value.toString());
            throw e;
        }
    }

    @Override
    public RequestParameter validateSingleParam(String value) throws ValidationException {
        if (this.allowEmptyValue() && value != null && value.length() == 0) {
            return RequestParameter.create(this.getName(), "");
        }
        return this.callValidator(value);
    }

    @Override
    public RequestParameter validateArrayParam(List<String> value) throws ValidationException {
        if (this.allowEmptyValue() && value != null && value.size() == 1 && value.get(0).length() == 0) {
            return RequestParameter.create(this.getName(), "");
        }
        return this.callValidator(value);
    }

    @Override
    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public ParameterTypeValidator parameterTypeValidator() {
        return this.validator;
    }

    @Override
    public boolean allowEmptyValue() {
        return this.allowEmptyValue;
    }

    public String toString() {
        return "ParameterValidationRuleImpl{name='" + this.name + '\'' + ", validator=" + this.validator + ", location=" + (Object)((Object)this.location) + ", isOptional=" + this.isOptional + ", allowEmptyValue=" + this.allowEmptyValue + '}';
    }

    public static class ParameterValidationRuleFactory {
        static ParameterValidationRule createValidationRule(String name, ParameterType type, boolean isOptional, boolean allowEmptyValue, ParameterLocation location) {
            return new ParameterValidationRuleImpl(name, type.validationMethod(), isOptional, allowEmptyValue, location);
        }

        public static ParameterValidationRule createValidationRuleWithCustomTypeValidator(String name, ParameterTypeValidator validator, boolean isOptional, boolean allowEmptyValue, ParameterLocation location) {
            return new ParameterValidationRuleImpl(name, validator, isOptional, allowEmptyValue, location);
        }
    }
}

