/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.impl.HttpRequestImpl;
import io.vertx.ext.web.client.impl.HttpResponseImpl;
import io.vertx.ext.web.codec.spi.BodyStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HttpContext {
    private final Handler<AsyncResult<HttpResponse<Object>>> responseHandler;
    private final HttpRequestImpl request;
    private final Object body;
    private String contentType;
    private Map<String, Object> attrs;
    private Handler<AsyncResult<HttpResponse<Object>>> currentResponseHandler;
    private Iterator<Handler<HttpContext>> it;

    public HttpContext(HttpRequest request, String contentType, Object body, Handler<AsyncResult<HttpResponse<Object>>> responseHandler) {
        this.request = (HttpRequestImpl)request;
        this.contentType = contentType;
        this.body = body;
        this.responseHandler = responseHandler;
    }

    public void interceptAndSend() {
        this.it = this.request.client.interceptors.iterator();
        this.currentResponseHandler = this.responseHandler;
        this.next();
    }

    public HttpRequest request() {
        return this.request;
    }

    public String contentType() {
        return this.contentType;
    }

    public Object body() {
        return this.body;
    }

    public Handler<AsyncResult<HttpResponse<Object>>> getResponseHandler() {
        return this.currentResponseHandler;
    }

    public void setResponseHandler(Handler<AsyncResult<HttpResponse<Object>>> responseHandler) {
        this.currentResponseHandler = responseHandler;
    }

    public void next() {
        if (this.it.hasNext()) {
            Handler<HttpContext> next = this.it.next();
            next.handle((Object)this);
        } else {
            this.sendRequest();
        }
    }

    private void sendRequest() {
        HttpClientRequest req;
        String requestURI;
        Future responseFuture = Future.future().setHandler(ar -> {
            Context context = Vertx.currentContext();
            if (ar.succeeded()) {
                HttpClientResponse resp = (HttpClientResponse)ar.result();
                Future fut = Future.future();
                fut.setHandler(r -> context.runOnContext(v -> this.currentResponseHandler.handle(r)));
                resp.exceptionHandler(err -> {
                    if (!fut.isComplete()) {
                        fut.fail(err);
                    }
                });
                resp.pause();
                this.request.codec.create(ar2 -> {
                    resp.resume();
                    if (ar2.succeeded()) {
                        BodyStream stream = (BodyStream)ar2.result();
                        stream.exceptionHandler(err -> {
                            if (!fut.isComplete()) {
                                fut.fail(err);
                            }
                        });
                        resp.endHandler(v -> {
                            if (!fut.isComplete()) {
                                stream.end();
                                if (stream.result().succeeded()) {
                                    fut.complete(new HttpResponseImpl<Object>(resp.version(), resp.statusCode(), resp.statusMessage(), resp.headers(), resp.trailers(), resp.cookies(), null, stream.result().result()));
                                } else {
                                    fut.fail(stream.result().cause());
                                }
                            }
                        });
                        Pump responsePump = Pump.pump((ReadStream)resp, (WriteStream)stream);
                        responsePump.start();
                    } else {
                        this.currentResponseHandler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
                    }
                });
            } else {
                this.currentResponseHandler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        if (this.request.queryParams() != null && this.request.queryParams().size() > 0) {
            QueryStringEncoder enc = new QueryStringEncoder(this.request.uri);
            this.request.queryParams().forEach(param -> enc.addParam((String)param.getKey(), (String)param.getValue()));
            requestURI = enc.toString();
        } else {
            requestURI = this.request.uri;
        }
        int port = this.request.port;
        String host = this.request.host;
        if (this.request.ssl != this.request.options.isSsl()) {
            req = this.request.client.client.request(this.request.method, new RequestOptions().setSsl(this.request.ssl).setHost(host).setPort(port).setURI(requestURI));
        } else if (this.request.protocol != null && !this.request.protocol.equals("http") && !this.request.protocol.equals("https")) {
            try {
                URI uri = new URI(this.request.protocol, null, host, port, requestURI, null, null);
                req = this.request.client.client.requestAbs(this.request.method, uri.toString());
            }
            catch (URISyntaxException ex) {
                this.currentResponseHandler.handle((Object)Future.failedFuture((Throwable)ex));
                return;
            }
        } else {
            req = this.request.client.client.request(this.request.method, port, host, requestURI);
        }
        if (this.request.virtualHost != null) {
            String virtalHost = this.request.virtualHost;
            if (port != 80) {
                virtalHost = virtalHost + ":" + port;
            }
            req.setHost(virtalHost);
        }
        req.setFollowRedirects(this.request.followRedirects);
        if (this.request.headers != null) {
            req.headers().addAll(this.request.headers);
        }
        req.handler(arg_0 -> ((Future)responseFuture).tryComplete(arg_0));
        if (this.request.timeout > 0L) {
            req.setTimeout(this.request.timeout);
        }
        if (this.body != null) {
            if (this.contentType != null) {
                String prev = req.headers().get(HttpHeaders.CONTENT_TYPE);
                if (prev == null) {
                    req.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)this.contentType);
                } else {
                    this.contentType = prev;
                }
            }
            if (this.body instanceof ReadStream) {
                ReadStream stream = (ReadStream)this.body;
                if (this.request.headers == null || !this.request.headers.contains(HttpHeaders.CONTENT_LENGTH)) {
                    req.setChunked(true);
                }
                Pump pump = Pump.pump((ReadStream)stream, (WriteStream)req);
                req.exceptionHandler(err -> {
                    pump.stop();
                    stream.endHandler(null);
                    stream.resume();
                    responseFuture.tryFail(err);
                });
                stream.exceptionHandler(err -> {
                    req.reset();
                    responseFuture.tryFail(err);
                });
                stream.endHandler(v -> {
                    req.exceptionHandler(arg_0 -> ((Future)responseFuture).tryFail(arg_0));
                    req.end();
                    pump.stop();
                });
                pump.start();
            } else {
                Buffer buffer;
                if (this.body instanceof Buffer) {
                    buffer = (Buffer)this.body;
                } else if (this.body instanceof MultiMap) {
                    try {
                        MultiMap attributes = (MultiMap)this.body;
                        boolean multipart = "multipart/form-data".equals(this.contentType);
                        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
                        HttpPostRequestEncoder encoder = new HttpPostRequestEncoder((io.netty.handler.codec.http.HttpRequest)request, multipart);
                        for (Map.Entry attribute : attributes) {
                            encoder.addBodyAttribute((String)attribute.getKey(), (String)attribute.getValue());
                        }
                        encoder.finalizeRequest();
                        for (String headerName : request.headers().names()) {
                            req.putHeader(headerName, request.headers().get(headerName));
                        }
                        if (encoder.isChunked()) {
                            HttpContent chunk;
                            ByteBuf content;
                            buffer = Buffer.buffer();
                            while ((content = (chunk = encoder.readChunk((ByteBufAllocator)new UnpooledByteBufAllocator(false))).content()).readableBytes() != 0) {
                                buffer.appendBuffer(Buffer.buffer((ByteBuf)content));
                            }
                        }
                        ByteBuf content = request.content();
                        buffer = Buffer.buffer((ByteBuf)content);
                    }
                    catch (Exception e) {
                        throw new VertxException((Throwable)e);
                    }
                } else {
                    buffer = this.body instanceof JsonObject ? Buffer.buffer((String)((JsonObject)this.body).encode()) : Buffer.buffer((String)Json.encode((Object)this.body));
                }
                req.exceptionHandler(arg_0 -> ((Future)responseFuture).tryFail(arg_0));
                req.end(buffer);
            }
        } else {
            req.exceptionHandler(arg_0 -> ((Future)responseFuture).tryFail(arg_0));
            req.end();
        }
    }

    public <T> T get(String key) {
        return (T)(this.attrs != null ? this.attrs.get(key) : null);
    }

    public HttpContext set(String key, Object value) {
        if (value == null) {
            if (this.attrs != null) {
                this.attrs.remove(key);
            }
        } else {
            if (this.attrs == null) {
                this.attrs = new HashMap<String, Object>();
            }
            this.attrs.put(key, value);
        }
        return this;
    }
}

