/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.zookeeper.impl;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.shareddata.impl.ClusterSerializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.curator.RetryLoop;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.framework.api.ErrorListenerPathable;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

abstract class ZKMap<K, V> {
    final CuratorFramework curator;
    protected final Vertx vertx;
    final String mapPath;
    protected final String mapName;
    static final String ZK_PATH_ASYNC_MAP = "asyncMap";
    static final String ZK_PATH_ASYNC_MULTI_MAP = "asyncMultiMap";
    static final String EVENTBUS_PATH = "/asyncMultiMap/__vertx.subs/";
    static final String ZK_PATH_SYNC_MAP = "syncMap";
    static final Predicate<String> pathChecker = path -> {
        if (path.contains("/")) {
            throw new IllegalArgumentException("can not contain forward slash char in ZK node path");
        }
        return true;
    };
    private RetryPolicy retryPolicy = new ExponentialBackoffRetry(100, 5);

    ZKMap(CuratorFramework curator, Vertx vertx, String mapType, String mapName) {
        pathChecker.test(mapName);
        this.curator = curator;
        this.vertx = vertx;
        this.mapName = mapName;
        this.mapPath = "/" + mapType + "/" + mapName;
    }

    String keyPath(K k) {
        pathChecker.test(k.toString());
        return this.mapPath + "/" + k.toString();
    }

    String valuePath(K k, Object v) {
        pathChecker.test(v.toString());
        return this.keyPath(k) + "/" + v.toString();
    }

    Future<Void> assertKeyIsNotNull(Object key) {
        boolean result;
        boolean bl = result = key == null;
        if (result) {
            return Future.failedFuture((String)"key can not be null.");
        }
        return Future.succeededFuture();
    }

    Future<Void> assertValueIsNotNull(Object value) {
        boolean result;
        boolean bl = result = value == null;
        if (result) {
            return Future.failedFuture((String)"value can not be null.");
        }
        return Future.succeededFuture();
    }

    Future<Void> assertKeyAndValueAreNotNull(Object key, Object value) {
        return this.assertKeyIsNotNull(key).compose(aVoid -> this.assertValueIsNotNull(value));
    }

    byte[] asByte(Object object) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOutput = new DataOutputStream(byteOut);
        if (object instanceof ClusterSerializable) {
            ClusterSerializable clusterSerializable = (ClusterSerializable)object;
            dataOutput.writeBoolean(true);
            dataOutput.writeUTF(object.getClass().getName());
            Buffer buffer = Buffer.buffer();
            clusterSerializable.writeToBuffer(buffer);
            byte[] bytes = buffer.getBytes();
            dataOutput.writeInt(bytes.length);
            dataOutput.write(bytes);
        } else {
            dataOutput.writeBoolean(false);
            ByteArrayOutputStream javaByteOut = new ByteArrayOutputStream();
            ObjectOutputStream objectOutput = new ObjectOutputStream(javaByteOut);
            objectOutput.writeObject(object);
            dataOutput.write(javaByteOut.toByteArray());
        }
        return byteOut.toByteArray();
    }

    <T> T asObject(byte[] bytes) throws Exception {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(bytes);
        DataInputStream in = new DataInputStream(byteIn);
        boolean isClusterSerializable = in.readBoolean();
        if (isClusterSerializable) {
            String className = in.readUTF();
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            int length = in.readInt();
            byte[] body = new byte[length];
            in.readFully(body);
            try {
                ClusterSerializable clusterSerializable;
                if (clazz.getConstructors().length == 0) {
                    Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    clusterSerializable = (ClusterSerializable)constructor.newInstance(new Object[0]);
                } else {
                    clusterSerializable = (ClusterSerializable)clazz.newInstance();
                }
                clusterSerializable.readFromBuffer(0, Buffer.buffer((byte[])body));
                return (T)clusterSerializable;
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load class " + e.getMessage(), e);
            }
        }
        byte[] body = new byte[in.available()];
        in.readFully(body);
        ObjectInputStream objectIn = new ObjectInputStream(new ByteArrayInputStream(body));
        return (T)objectIn.readObject();
    }

    <T> T getData(Stat stat, String path) throws Exception {
        T result = null;
        if (null != this.curator.checkExists().forPath(path)) {
            result = this.asObject((byte[])((WatchPathable)this.curator.getData().storingStatIn(stat)).forPath(path));
        } else {
            this.curator.create().creatingParentsIfNeeded().forPath(path, this.asByte(null));
        }
        return result;
    }

    boolean compareAndSet(long startTime, int retries, Stat stat, String path, V expect, V update) throws Exception {
        Object currentValue = this.getData(stat, path);
        if (currentValue == expect || currentValue.equals(expect)) {
            block3: {
                try {
                    ((BackgroundPathAndBytesable)this.curator.setData().withVersion(stat.getVersion())).forPath(path, this.asByte(update));
                }
                catch (KeeperException.BadVersionException | KeeperException.NoNodeException e) {
                    if (this.retryPolicy.allowRetry(retries, Instant.now().toEpochMilli() - startTime, RetryLoop.getDefaultRetrySleeper())) break block3;
                    throw new VertxException("failed to acquire optimistic lock");
                }
            }
            return true;
        }
        return false;
    }

    Future<Boolean> checkExists(K k) {
        return this.checkExists(this.keyPath(k));
    }

    Future<Boolean> checkExists(String path) {
        Future future = Future.future();
        try {
            ((ErrorListenerPathable)this.curator.sync().inBackground((clientSync, eventSync) -> {
                try {
                    if (eventSync.getType() == CuratorEventType.SYNC) {
                        ((ErrorListenerPathable)this.curator.checkExists().inBackground((clientCheck, eventCheck) -> {
                            if (eventCheck.getType() == CuratorEventType.EXISTS) {
                                if (eventCheck.getStat() == null) {
                                    this.vertx.runOnContext(aVoid -> future.complete((Object)false));
                                } else {
                                    this.vertx.runOnContext(aVoid -> future.complete((Object)true));
                                }
                            }
                        })).forPath(path);
                    }
                }
                catch (Exception ex) {
                    this.vertx.runOnContext(aVoid -> future.fail((Throwable)ex));
                }
            })).forPath(path);
        }
        catch (Exception ex) {
            this.vertx.runOnContext(aVoid -> future.fail((Throwable)ex));
        }
        return future;
    }

    Future<Stat> create(K k, V v) {
        return this.create(this.keyPath(k), v);
    }

    Future<Stat> create(String path, V v) {
        Future future = Future.future();
        try {
            CreateMode nodeMode = path.contains(EVENTBUS_PATH) ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT;
            ((ErrorListenerPathAndBytesable)((ACLBackgroundPathAndBytesable)this.curator.create().creatingParentsIfNeeded().withMode(nodeMode)).inBackground((cl, el) -> {
                if (el.getType() == CuratorEventType.CREATE) {
                    this.vertx.runOnContext(event -> future.complete((Object)el.getStat()));
                }
            })).forPath(path, this.asByte(v));
        }
        catch (Exception ex) {
            this.vertx.runOnContext(event -> future.fail((Throwable)ex));
        }
        return future;
    }

    Future<Stat> setData(K k, V v) {
        return this.setData(this.keyPath(k), v);
    }

    Future<Stat> setData(String path, V v) {
        Future future = Future.future();
        try {
            ((ErrorListenerPathAndBytesable)this.curator.setData().inBackground((client, event) -> {
                if (event.getType() == CuratorEventType.SET_DATA) {
                    this.vertx.runOnContext(e -> future.complete((Object)event.getStat()));
                }
            })).forPath(path, this.asByte(v));
        }
        catch (Exception ex) {
            this.vertx.runOnContext(event -> future.fail((Throwable)ex));
        }
        return future;
    }

    Future<V> delete(K k, V v) {
        return this.delete(this.keyPath(k), v);
    }

    Future<V> delete(String path, V v) {
        Future future = Future.future();
        try {
            ((ErrorListenerPathable)this.curator.delete().deletingChildrenIfNeeded().inBackground((client, event) -> {
                if (event.getType() == CuratorEventType.DELETE) {
                    String[] paths = path.split("/");
                    String parentNodePath = Stream.of(paths).limit(paths.length - 1).reduce((previous, current) -> previous + "/" + current).get();
                    ((ErrorListenerPathable)this.curator.getChildren().inBackground((childClient, childEvent) -> {
                        if (childEvent.getChildren().size() == 0) {
                            ((ErrorListenerPathable)this.curator.delete().inBackground((deleteClient, deleteEvent) -> {
                                if (deleteEvent.getType() == CuratorEventType.DELETE) {
                                    this.vertx.runOnContext(ea -> future.complete(v));
                                }
                            })).forPath(parentNodePath);
                        } else {
                            this.vertx.runOnContext(ea -> future.complete(v));
                        }
                    })).forPath(parentNodePath);
                }
            })).forPath(path);
        }
        catch (Exception ex) {
            this.vertx.runOnContext(aVoid -> future.fail((Throwable)ex));
        }
        return future;
    }
}

