/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.testing.mock.aem;

import com.day.cq.commons.RangeIterator;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagException;
import com.day.cq.tagging.TagManager;
import io.wcm.testing.mock.aem.CollectionRangeIterator;
import java.lang.reflect.Field;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.jcr.Session;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public final class MockTagManager
implements TagManager {
    private static final String TAG_RESOURCE_TYPE = "cq/tagging/components/tag";
    private static final String TAG_ROOT_PATH = MockTagManager.detectTagRootPath();
    private static final String LEGACY_TAG_ROOT_PATH = "/etc/tags";
    private final ResourceResolver resourceResolver;
    private final Logger log;

    MockTagManager(@NotNull ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        this.log = LoggerFactory.getLogger(TagManager.class);
        this.initTagsStructure();
    }

    public static String getTagRootPath() {
        return TAG_ROOT_PATH;
    }

    private static String detectTagRootPath() {
        try {
            Class<?> tagConstantsClass = MockTagManager.class.getClassLoader().loadClass("com.day.cq.tagging.TagConstants");
            Field field = tagConstantsClass.getField("TAG_ROOT_PATH");
            return (String)field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            return LEGACY_TAG_ROOT_PATH;
        }
    }

    private void initTagsStructure() {
        Resource defaultNamespace = this.resourceResolver.getResource(MockTagManager.getTagRootPath() + "/" + "default");
        if (defaultNamespace != null) {
            return;
        }
        HashMap<String, String> etcProperties = new HashMap<String, String>();
        etcProperties.put("jcr:primaryType", "sling:Folder");
        HashMap<String, Object> tagsProperties = new HashMap<String, Object>();
        tagsProperties.put("jcr:primaryType", "sling:Folder");
        tagsProperties.put("jcr:title", "Tags");
        tagsProperties.put("languages", new String[]{"en", "de", "es", "fr", "it", "pt_br", "zh_cn", "ch_tw", "ja", "ko_kr"});
        try {
            ResourceUtil.getOrCreateResource((ResourceResolver)this.resourceResolver, (String)"/etc", etcProperties, null, (boolean)true);
            ResourceUtil.getOrCreateResource((ResourceResolver)this.resourceResolver, (String)MockTagManager.getTagRootPath(), tagsProperties, null, (boolean)true);
            this.createTag(TagConstants.DEFAULT_NAMESPACE_ID, "Standard Tags", null);
        }
        catch (InvalidTagFormatException | PersistenceException e) {
            this.log.error("Error creating tags tree", e);
        }
    }

    private String getPathFromID(String tagID) throws InvalidTagFormatException {
        if (tagID == null) {
            throw new InvalidTagFormatException("tagID is null");
        }
        if (StringUtils.startsWith((CharSequence)tagID, (CharSequence)MockTagManager.getTagRootPath())) {
            if (!tagID.startsWith(MockTagManager.getTagRootPath())) {
                throw new InvalidTagFormatException("Tags are only allowed to be under " + MockTagManager.getTagRootPath());
            }
            return tagID;
        }
        if (tagID.contains(TagConstants.NAMESPACE_DELIMITER)) {
            String tagPath = tagID.replaceFirst(TagConstants.NAMESPACE_DELIMITER, "/");
            if (tagPath.contains(TagConstants.NAMESPACE_DELIMITER)) {
                throw new InvalidTagFormatException("tag ID contains multiple namespace declarations");
            }
            if (tagPath.endsWith("/")) {
                tagPath = tagPath.substring(0, tagPath.length() - 1);
            }
            return MockTagManager.getTagRootPath() + "/" + tagPath;
        }
        return MockTagManager.getTagRootPath() + "/" + "default" + "/" + tagID;
    }

    public boolean canCreateTag(String tagID) throws InvalidTagFormatException {
        String tagPath = this.getPathFromID(tagID);
        return this.resourceResolver.getResource(tagPath) == null;
    }

    public Tag createTag(String tagID, String title, String description) throws AccessControlException, InvalidTagFormatException {
        return this.createTag(tagID, title, description, true);
    }

    public Tag createTag(String tagID, String title, String description, boolean autoSave) throws AccessControlException, InvalidTagFormatException {
        String tagPath = this.getPathFromID(tagID);
        if (!StringUtils.startsWith((CharSequence)tagPath, (CharSequence)TAG_ROOT_PATH)) {
            throw new InvalidTagFormatException("Tag path '" + tagPath + "' does not start with: " + TAG_ROOT_PATH);
        }
        Resource tagResource = this.resourceResolver.getResource(tagPath);
        if (tagResource != null) {
            return (Tag)tagResource.adaptTo(Tag.class);
        }
        String parentTagPath = tagPath.substring(0, tagPath.lastIndexOf(47));
        if (!MockTagManager.getTagRootPath().equals(parentTagPath)) {
            this.createTag(parentTagPath, null, null, false);
        }
        HashMap<String, Object> tagProps = new HashMap<String, Object>();
        tagProps.put("jcr:primaryType", "cq:Tag");
        tagProps.put("sling:resourceType", TAG_RESOURCE_TYPE);
        if (title != null) {
            tagProps.put("jcr:title", title);
        }
        if (description != null) {
            tagProps.put("jcr:description", description);
        }
        tagProps.put("jcr:lastModified", Calendar.getInstance());
        tagProps.put("jcr:lastModifiedBy", this.resourceResolver.getUserID());
        try {
            tagResource = ResourceUtil.getOrCreateResource((ResourceResolver)this.resourceResolver, (String)tagPath, tagProps, null, (boolean)autoSave);
            return (Tag)tagResource.adaptTo(Tag.class);
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("failed to create tag", ex);
        }
    }

    public Tag createTagByTitle(String titlePath) throws AccessControlException, InvalidTagFormatException {
        return this.createTagByTitle(titlePath, true);
    }

    public void deleteTag(Tag tag) throws AccessControlException {
        this.deleteTag(tag, true);
    }

    public void deleteTag(Tag tag, boolean autoSave) throws AccessControlException {
        Resource tagResource = (Resource)tag.adaptTo(Resource.class);
        if (tagResource == null) {
            return;
        }
        try {
            this.resourceResolver.delete(tagResource);
            if (autoSave) {
                this.resourceResolver.commit();
                this.resourceResolver.refresh();
            }
        }
        catch (PersistenceException e) {
            this.log.error("error deleting tag", (Throwable)e);
        }
    }

    public RangeIterator<Resource> find(String tagID) {
        return this.find("/", new String[]{tagID}, false);
    }

    public RangeIterator<Resource> find(String basePath, String[] tagIDs) {
        return this.find(basePath, tagIDs, false);
    }

    /*
     * Could not resolve type clashes
     */
    public RangeIterator<Resource> find(String basePath, String[] tagIDs, boolean oneMatchIsEnough) {
        Resource base = this.resourceResolver.getResource(basePath);
        if (base == null) {
            return new CollectionRangeIterator<Resource>(Collections.emptyList());
        }
        HashSet<String> tagPaths = new HashSet<String>(tagIDs.length);
        for (String tagID : tagIDs) {
            Tag tag = this.resolve(tagID);
            if (tag == null) {
                return null;
            }
            Resource tagResource = (Resource)tag.adaptTo(Resource.class);
            if (tagResource == null) continue;
            tagPaths.add(tagResource.getPath());
        }
        LinkedList<Resource> searchResources = new LinkedList<Resource>();
        searchResources.add(base);
        ArrayList<Resource> matchedResources = new ArrayList<Resource>();
        while (!searchResources.isEmpty()) {
            boolean matches;
            Resource resource;
            block13: {
                resource = (Resource)searchResources.poll();
                CollectionUtils.addAll(searchResources, (Iterator)resource.listChildren());
                String[] resourceTags = (String[])resource.getValueMap().get("cq:tags", String[].class);
                if (resourceTags == null) continue;
                ArrayList<String> resourceTagPaths = new ArrayList<String>(resourceTags.length);
                try {
                    for (Object resourceTag : resourceTags) {
                        resourceTagPaths.add(this.getPathFromID((String)resourceTag));
                    }
                }
                catch (InvalidTagFormatException e) {
                    this.log.error("invalid tag id encountered", (Throwable)e);
                }
                if (resourceTagPaths.isEmpty()) continue;
                matches = false;
                if (oneMatchIsEnough) {
                    for (String tagPath : tagPaths) {
                        Object resourceTag;
                        resourceTag = resourceTagPaths.iterator();
                        while (resourceTag.hasNext()) {
                            String resourceTagPath = (String)resourceTag.next();
                            matches = this.doTagsMatch(resourceTagPath, tagPath);
                            if (!matches) continue;
                            break block13;
                        }
                    }
                } else {
                    matches = true;
                    for (String tagPath : tagPaths) {
                        boolean tagMatched = false;
                        Iterator resourceTagPathIter = resourceTagPaths.iterator();
                        while (!tagMatched && resourceTagPathIter.hasNext()) {
                            String resourceTagPath = (String)resourceTagPathIter.next();
                            tagMatched = this.doTagsMatch(resourceTagPath, tagPath);
                        }
                        if (tagMatched) continue;
                        matches = false;
                        break;
                    }
                }
            }
            if (!matches) continue;
            matchedResources.add(resource);
        }
        return new CollectionRangeIterator<Resource>(matchedResources);
    }

    private boolean doTagsMatch(String haystack, String needle) {
        return haystack.equals(needle) || haystack.startsWith(needle + "/");
    }

    private List<Tag> getNamespacesList() {
        ArrayList<Tag> namespaces = new ArrayList<Tag>();
        Resource tagRoot = this.resourceResolver.getResource(MockTagManager.getTagRootPath());
        if (tagRoot != null) {
            Iterator resources = tagRoot.listChildren();
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                Tag tag = (Tag)resource.adaptTo(Tag.class);
                if (tag == null) continue;
                namespaces.add(tag);
            }
        }
        return namespaces;
    }

    public Tag[] getNamespaces() {
        List<Tag> namespaces = this.getNamespacesList();
        return namespaces.toArray(new Tag[0]);
    }

    public Iterator<Tag> getNamespacesIter() {
        return this.getNamespacesList().iterator();
    }

    public Session getSession() {
        return (Session)this.resourceResolver.adaptTo(Session.class);
    }

    public Tag[] getTags(Resource resource) {
        return this.getTagsForSubtree(resource, true);
    }

    public Tag[] getTagsForSubtree(Resource resource, boolean shallow) {
        Collection<Tag> tags = this.collectResourceTags(resource, !shallow);
        return tags.toArray(new Tag[0]);
    }

    private Collection<Tag> collectResourceTags(Resource resource, boolean recurse) {
        if (resource == null) {
            return Collections.emptyList();
        }
        HashSet<Tag> treeTags = new HashSet<Tag>();
        LinkedList<Resource> searchResources = new LinkedList<Resource>();
        searchResources.add(resource);
        while (!searchResources.isEmpty()) {
            String[] tags;
            Resource searchResource = (Resource)searchResources.poll();
            if (recurse) {
                CollectionUtils.addAll(searchResources, (Iterator)searchResource.listChildren());
            }
            if ((tags = (String[])searchResource.getValueMap().get("cq:tags", String[].class)) == null) continue;
            for (String tagStr : tags) {
                Tag tag = this.resolve(tagStr);
                if (tag == null) continue;
                treeTags.add(tag);
            }
        }
        return treeTags;
    }

    public Tag resolve(String tagID) {
        try {
            String path = this.getPathFromID(tagID);
            Resource tagResource = this.resourceResolver.getResource(path);
            if (tagResource != null) {
                return (Tag)tagResource.adaptTo(Tag.class);
            }
        }
        catch (InvalidTagFormatException invalidTagFormatException) {
            // empty catch block
        }
        return null;
    }

    public void setTags(Resource resource, Tag[] tags) {
        this.setTags(resource, tags, true);
    }

    public void setTags(Resource resource, Tag[] tags, boolean autoSave) {
        ModifiableValueMap props = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (props == null) {
            throw new RuntimeException("Unable to get modifiable value map: " + resource.getPath());
        }
        if (tags == null) {
            props.remove((Object)"cq:tags");
        } else {
            String[] tagStrings = new String[tags.length];
            for (int i = 0; i < tags.length; ++i) {
                tagStrings[i] = tags[i].getTagID();
            }
            props.put((Object)"cq:tags", (Object)tagStrings);
        }
        if (autoSave) {
            try {
                this.resourceResolver.commit();
            }
            catch (PersistenceException e) {
                this.log.error("failed to commit updates for setting tags", (Throwable)e);
            }
        }
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public boolean canCreateTagByTitle(String tagTitlePath) throws InvalidTagFormatException {
        throw new UnsupportedOperationException();
    }

    public boolean canCreateTagByTitle(String tagTitlePath, Locale locale) throws InvalidTagFormatException {
        throw new UnsupportedOperationException();
    }

    public Tag createTagByTitle(String titlePath, boolean autoSave) throws AccessControlException, InvalidTagFormatException {
        throw new UnsupportedOperationException();
    }

    public Tag createTagByTitle(String titlePath, Locale locale) throws AccessControlException, InvalidTagFormatException {
        throw new UnsupportedOperationException();
    }

    public RangeIterator<Resource> find(String basePath, List<String[]> tagSetIDs) {
        throw new UnsupportedOperationException();
    }

    public TagManager.FindResults findByTitle(String title) {
        throw new UnsupportedOperationException();
    }

    public void mergeTag(Tag tag, Tag destination) throws AccessControlException, TagException {
        throw new UnsupportedOperationException();
    }

    public Tag moveTag(Tag tag, String destination) throws AccessControlException, InvalidTagFormatException, TagException {
        throw new UnsupportedOperationException();
    }

    public Tag resolveByTitle(String tagTitlePath) {
        throw new UnsupportedOperationException();
    }

    public Tag resolveByTitle(String tagTitlePath, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public Tag[] findTagsByTitle(String keyword, Locale locale) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Tag> findTagsByKeyword(String arg0, Locale arg1, String arg2) {
        throw new UnsupportedOperationException();
    }

    public List<String> getSupportedLanguageCodes() {
        throw new UnsupportedOperationException();
    }
}

