/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.maven.plugins.nodejs.installation;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.Os;

public class NodeInstallationInformation {
    private static final String NODEJS_BINARIES_GROUPID = "org.nodejs.dist";
    private static final String NODEJS_BINARIES_ARTIFACTID = "nodejs-binaries";
    private static final String NPM_BINARIES_ARTIFACTID = "npm-binaries";
    private static final String LATEST_WINDOWS_NPM_VERSION = "1.4.9";
    private Dependency nodeJsDependency;
    private Dependency npmDependency;
    private File archive;
    private File npmArchive;
    private File nodeExecutable;
    private File npmExecutable;
    private String basePath;

    public Dependency getNodeJsDependency() {
        return this.nodeJsDependency;
    }

    public void setNodeJsDependency(Dependency nodeJsDependency) {
        this.nodeJsDependency = nodeJsDependency;
    }

    public Dependency getNpmDependency() {
        return this.npmDependency;
    }

    public void setNpmDependency(Dependency npmDependency) {
        this.npmDependency = npmDependency;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public File getNodeExecutable() {
        return this.nodeExecutable;
    }

    public void setNodeExecutable(File nodeExecutable) {
        this.nodeExecutable = nodeExecutable;
    }

    public File getNpmExecutable() {
        return this.npmExecutable;
    }

    public void setNpmExecutable(File npmExecutable) {
        this.npmExecutable = npmExecutable;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public static NodeInstallationInformation forVersion(String version, String npmVersion, File directory) throws MojoExecutionException {
        String arch;
        String basePath = directory.getAbsolutePath() + File.separator;
        if (Os.isArch((String)"x86") || Os.isArch((String)"i386")) {
            arch = "x86";
        } else if (Os.isArch((String)"x86_64") || Os.isArch((String)"amd64")) {
            arch = "x64";
        } else {
            throw new MojoExecutionException("Unsupported OS arch: " + Os.OS_ARCH);
        }
        NodeInstallationInformation result = new NodeInstallationInformation();
        result.setBasePath(basePath);
        if (Os.isFamily((String)"windows") || Os.isFamily((String)"win9x")) {
            String windowsNpmVersion = NodeInstallationInformation.getWindowsNpmVersion(npmVersion);
            basePath = basePath + "v-" + version + File.separator;
            result.setNodeJsDependency(NodeInstallationInformation.buildDependency(NODEJS_BINARIES_GROUPID, NODEJS_BINARIES_ARTIFACTID, version, "windows", arch, "exe"));
            result.setNpmDependency(NodeInstallationInformation.buildDependency(NODEJS_BINARIES_GROUPID, NPM_BINARIES_ARTIFACTID, windowsNpmVersion, null, null, "tgz"));
            result.setArchive(new File(basePath + "node.exe"));
            result.setNpmArchive(new File(basePath + "npm-" + windowsNpmVersion + ".tgz"));
            result.setNodeExecutable(new File(basePath + "node.exe"));
            result.setNpmExecutable(new File(basePath + "npm/bin/npm-cli.js"));
        } else if (Os.isFamily((String)"mac")) {
            result.setNodeJsDependency(NodeInstallationInformation.buildDependency(NODEJS_BINARIES_GROUPID, NODEJS_BINARIES_ARTIFACTID, version, "darwin", arch, "tar.gz"));
            result.setArchive(new File(basePath + "node-v" + version + "-darwin-" + arch + ".tar.gz"));
            result.setNodeExecutable(new File(basePath + "node-v" + version + "-darwin-" + arch + File.separator + "bin" + File.separator + "node"));
            result.setNpmExecutable(new File(basePath + "node-v" + version + "-darwin-" + arch + File.separator + "lib" + File.separator + "node_modules/npm/bin/npm-cli.js"));
        } else if (Os.isFamily((String)"unix")) {
            result.setNodeJsDependency(NodeInstallationInformation.buildDependency(NODEJS_BINARIES_GROUPID, NODEJS_BINARIES_ARTIFACTID, version, "linux", arch, "tar.gz"));
            result.setArchive(new File(basePath + "node-v" + version + "-linux-" + arch + ".tar.gz"));
            result.setNodeExecutable(new File(basePath + "node-v" + version + "-linux-" + arch + File.separator + "bin" + File.separator + "node"));
            result.setNpmExecutable(new File(basePath + "node-v" + version + "-linux-" + arch + File.separator + "lib" + File.separator + "node_modules/npm/bin/npm-cli.js"));
        } else {
            throw new MojoExecutionException("Unsupported OS: " + Os.OS_FAMILY);
        }
        return result;
    }

    private static Dependency buildDependency(String groupId, String artifactId, String version, String os, String arch, String type) {
        String classifier = null;
        if (StringUtils.isNotEmpty((CharSequence)os)) {
            classifier = os;
        }
        if (StringUtils.isNotEmpty((CharSequence)arch)) {
            classifier = classifier + "-" + arch;
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        return dependency;
    }

    public static void setSpecifiedNpmExecutable(NodeInstallationInformation information, File directory) throws MojoExecutionException {
        String basePath = directory.getAbsolutePath() + File.separator;
        if (Os.isFamily((String)"windows") || Os.isFamily((String)"win9x")) {
            information.setNpmExecutable(new File(basePath + "node_modules/npm/bin/npm-cli.js"));
        } else if (Os.isFamily((String)"mac")) {
            information.setNpmExecutable(new File(basePath + "node_modules/npm/bin/npm-cli.js"));
        } else if (Os.isFamily((String)"unix")) {
            information.setNpmExecutable(new File(basePath + "node_modules/npm/bin/npm-cli.js"));
        } else {
            throw new MojoExecutionException("Unsupported OS: " + Os.OS_FAMILY);
        }
    }

    private static String getWindowsNpmVersion(String npmVersion) {
        if (StringUtils.startsWith((CharSequence)npmVersion, (CharSequence)"1.")) {
            return npmVersion;
        }
        return LATEST_WINDOWS_NPM_VERSION;
    }

    public File getNpmArchive() {
        return this.npmArchive;
    }

    public void setNpmArchive(File npmArchive) {
        this.npmArchive = npmArchive;
    }
}

